/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractMutableQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.PaginationContextImpl;
import org.babyfish.jimmer.sql.ast.impl.query.TypedQueryData;
import org.babyfish.jimmer.sql.ast.impl.query.TypedQueryImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.impl.table.TableSelection;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.PropExpressionImplementor;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherSelection;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.FormulaTemplate;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.SqlTemplate;
import org.babyfish.jimmer.sql.meta.Storage;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

class AbstractConfigurableTypedQueryImpl
implements TypedQueryImplementor {
    private final TypedQueryData data;
    private final AbstractMutableQueryImpl baseQuery;

    public AbstractConfigurableTypedQueryImpl(TypedQueryData data, AbstractMutableQueryImpl baseQuery) {
        this.data = data;
        this.baseQuery = baseQuery;
    }

    public AbstractMutableQueryImpl getBaseQuery() {
        return this.baseQuery;
    }

    public TypedQueryData getData() {
        return this.data;
    }

    @Override
    public List<Selection<?>> getSelections() {
        return this.data.selections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(@NotNull AstVisitor visitor) {
        AstContext astContext = visitor.getAstContext();
        astContext.pushStatement(this.getBaseQuery());
        try {
            PropExpressionImplementor<?> idOnlySelection = this.idOnlyPropExprByOffset();
            if (idOnlySelection != null) {
                this.baseQuery.accept(visitor, Collections.singletonList(idOnlySelection), false);
            } else {
                for (Selection<?> selection : this.data.selections) {
                    Ast.from(selection, visitor.getAstContext()).accept(visitor);
                }
                this.baseQuery.accept(visitor, this.data.oldSelections, this.data.withoutSortingAndPaging);
            }
        }
        finally {
            astContext.popStatement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        AstContext astContext = builder.getAstContext();
        astContext.pushStatement(this.getBaseQuery());
        try {
            if (this.data.withoutSortingAndPaging || this.data.limit == Integer.MAX_VALUE) {
                this.renderWithoutPaging(builder, null);
            } else {
                PropExpressionImplementor<?> idPropExpr = this.idOnlyPropExprByOffset();
                if (idPropExpr != null) {
                    this.renderIdOnlyQuery(idPropExpr, builder);
                } else {
                    SqlBuilder subBuilder = builder.createChildBuilder();
                    this.renderWithoutPaging(subBuilder, null);
                    subBuilder.build(result -> {
                        PaginationContextImpl ctx = new PaginationContextImpl(this.getBaseQuery().getSqlClient().getSqlFormatter(), this.data.limit, this.data.offset, (String)result.get_1(), (List)result.get_2(), (List)result.get_3(), false);
                        this.baseQuery.getSqlClient().getDialect().paginate(ctx);
                        return ctx.build();
                    });
                }
            }
            if (this.data.forUpdate) {
                builder.sql(" for update");
            }
        }
        finally {
            astContext.popStatement();
        }
    }

    private void renderWithoutPaging(SqlBuilder builder, PropExpressionImplementor<?> idPropExpr) {
        builder.enter(this.data.distinct ? SqlBuilder.ScopeType.SELECT_DISTINCT : SqlBuilder.ScopeType.SELECT);
        if (idPropExpr != null) {
            TableImplementor<?> tableImplementor = TableProxies.resolve(idPropExpr.getTable(), builder.getAstContext());
            tableImplementor.renderSelection(tableImplementor.getImmutableType().getIdProp(), builder, null, true, OffsetOptimizationWriter::idAlias);
        } else {
            for (Selection<?> selection : this.data.selections) {
                TableImplementor tableSelection;
                builder.separator();
                if (selection instanceof TableSelection) {
                    tableSelection = (TableImplementor)selection;
                    AbstractConfigurableTypedQueryImpl.renderAllProps(tableSelection, builder);
                    continue;
                }
                if (selection instanceof Table) {
                    tableSelection = TableProxies.resolve((Table)selection, builder.getAstContext());
                    AbstractConfigurableTypedQueryImpl.renderAllProps(tableSelection, builder);
                    continue;
                }
                Ast ast = Ast.from(selection, builder.getAstContext());
                if (ast instanceof PropExpressionImplementor) {
                    ((PropExpressionImplementor)((Object)ast)).renderTo(builder, true);
                    continue;
                }
                ast.renderTo(builder);
            }
        }
        builder.leave();
        this.baseQuery.renderTo(builder, this.data.withoutSortingAndPaging, this.data.reverseSorting);
    }

    private PropExpressionImplementor<?> idOnlyPropExprByOffset() {
        if (this.data.offset >= this.baseQuery.getSqlClient().getOffsetOptimizingThreshold()) {
            return this.data.getIdOnlyExpression();
        }
        return null;
    }

    private static void renderAllProps(TableSelection table, SqlBuilder builder) {
        Map selectableProps = table.getImmutableType().getSelectableProps();
        for (ImmutableProp prop : selectableProps.values()) {
            builder.separator();
            table.renderSelection(prop, builder, null);
        }
    }

    private void renderIdOnlyQuery(PropExpressionImplementor<?> idPropExpr, SqlBuilder builder) {
        MetadataStrategy strategy = builder.getAstContext().getSqlClient().getMetadataStrategy();
        OffsetOptimizationWriter writer = new OffsetOptimizationWriter(builder, strategy);
        TableImplementor<?> tableImplementor = TableProxies.resolve(idPropExpr.getTable(), builder.getAstContext());
        builder.enter(SqlBuilder.ScopeType.SELECT);
        if (this.data.selections.get(0) instanceof FetcherSelection) {
            for (Field field : ((FetcherSelection)this.data.selections.get(0)).getFetcher().getFieldMap().values()) {
                writer.prop(field.getProp(), "optimize_", false);
            }
        } else {
            for (ImmutableProp prop : tableImplementor.getImmutableType().getProps().values()) {
                writer.prop(prop, "optimize_", false);
            }
        }
        builder.leave();
        builder.from().enter(SqlBuilder.ScopeType.SUB_QUERY);
        SqlBuilder subBuilder = builder.createChildBuilder();
        this.renderWithoutPaging(subBuilder, idPropExpr);
        subBuilder.build(result -> {
            PaginationContextImpl ctx = new PaginationContextImpl(this.getBaseQuery().getSqlClient().getSqlFormatter(), this.data.limit, this.data.offset, (String)result.get_1(), (List)result.get_2(), (List)result.get_3(), true);
            this.baseQuery.getSqlClient().getDialect().paginate(ctx);
            return ctx.build();
        });
        builder.leave().sql(" ").sql("optimize_core_").sql(" inner join ").sql(tableImplementor.getImmutableType().getTableName(strategy)).sql(" ").sql("optimize_").on();
        writer.prop(tableImplementor.getImmutableType().getIdProp(), "optimize_", true);
        builder.sql(" = ");
        int size = ((ColumnDefinition)tableImplementor.getImmutableType().getIdProp().getStorage(strategy)).size();
        if (size == 1) {
            builder.sql("optimize_core_").sql(".");
            builder.sql(OffsetOptimizationWriter.idAlias(0));
        } else {
            builder.sql("(");
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    builder.sql(", ");
                }
                builder.sql("optimize_core_").sql(".");
                builder.sql(OffsetOptimizationWriter.idAlias(i));
            }
            builder.sql(")");
        }
        if (this.getBaseQuery().getSqlClient().getDialect().getOffsetOptimizationNumField() != null) {
            builder.enter(SqlBuilder.ScopeType.ORDER_BY).sql("optimize_core_").sql(".").sql("optimize_rn__").leave();
        }
    }

    private static class OffsetOptimizationWriter {
        private static final String ALIAS = "optimize_";
        private static final String CORE_ALIAS = "optimize_core_";
        private static final String CORE_ID_ALIAS = "optimize_core_id_";
        private static final String ROW_NUMBER_ALIAS = "optimize_rn__";
        private final SqlBuilder builder;
        private final MetadataStrategy strategy;

        OffsetOptimizationWriter(SqlBuilder builder, MetadataStrategy strategy) {
            this.builder = builder;
            this.strategy = strategy;
        }

        public void prop(ImmutableProp prop, String alias, boolean multiColumnsAsTuple) {
            SqlTemplate template = prop.getSqlTemplate();
            if (template instanceof FormulaTemplate) {
                this.builder.separator().sql(((FormulaTemplate)template).toSql(alias));
                return;
            }
            Storage storage = prop.getStorage(this.strategy);
            if (storage instanceof ColumnDefinition) {
                ColumnDefinition definition = (ColumnDefinition)storage;
                int size = definition.size();
                if (size == 1) {
                    this.builder.separator().sql(alias).sql(".").sql(definition.name(0));
                } else if (multiColumnsAsTuple) {
                    this.builder.enter(SqlBuilder.ScopeType.TUPLE);
                    for (int i = 0; i < size; ++i) {
                        this.builder.separator().sql(alias).sql(".").sql(definition.name(i));
                    }
                    this.builder.leave();
                } else {
                    for (int i = 0; i < size; ++i) {
                        this.builder.separator().sql(alias).sql(".").sql(definition.name(i));
                    }
                }
            }
        }

        public static String idAlias(int index) {
            return index == 0 ? CORE_ID_ALIAS : CORE_ID_ALIAS + index + '_';
        }
    }
}

