/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.query;

import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import org.babyfish.jimmer.sql.ast.impl.query.ConfigurableRootQueryImplementor;
import org.babyfish.jimmer.sql.ast.query.ConfigurableRootQuery;

public class PagingQueries {
    private PagingQueries() {
    }

    public static <E, P> P execute(ConfigurableRootQuery<?, E> query, int pageIndex, int pageSize, PageFactory<E, P> pageFactory) {
        return PagingQueries.execute(query, pageIndex, pageSize, null, pageFactory);
    }

    public static <E, P> P execute(ConfigurableRootQuery<?, E> query, int pageIndex, int pageSize, Connection con, PageFactory<E, P> pageFactory) {
        List entities;
        ConfigurableRootQueryImplementor queryImplementor = (ConfigurableRootQueryImplementor)query;
        if (pageSize == 0) {
            List entities2 = (List)query.execute(con);
            return pageFactory.create(entities2, entities2.size(), queryImplementor);
        }
        if (pageIndex < 0) {
            return pageFactory.create(Collections.emptyList(), 0, queryImplementor);
        }
        long longOffset = (long)pageIndex * (long)pageSize;
        if (longOffset > (long)(Integer.MAX_VALUE - pageSize)) {
            throw new IllegalArgumentException("offset is too big");
        }
        int total = query.count(con);
        if (longOffset >= (long)total) {
            return pageFactory.create(Collections.emptyList(), 0, queryImplementor);
        }
        ConfigurableRootQuery<?, E> reversedQuery = null;
        if (longOffset + (long)(pageSize / 2) > (long)(total / 2)) {
            reversedQuery = query.reverseSorting();
        }
        if (reversedQuery != null) {
            int limit;
            int offset = (int)((long)total - longOffset - (long)pageSize);
            if (offset < 0) {
                limit = pageSize + offset;
                offset = 0;
            } else {
                limit = pageSize;
            }
            entities = (List)reversedQuery.limit(limit, offset).execute(con);
            Collections.reverse(entities);
        } else {
            entities = (List)query.limit(pageSize, (int)longOffset).execute(con);
        }
        return pageFactory.create(entities, total, queryImplementor);
    }

    @FunctionalInterface
    public static interface PageFactory<E, P> {
        public P create(List<E> var1, int var2, ConfigurableRootQueryImplementor<?, E> var3);
    }
}

