/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.util.List;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ExistsPredicate;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.SubQueryFunctionExpression;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractConfigurableTypedQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MergedTypedSubQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MutableSubQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.TypedQueryData;
import org.babyfish.jimmer.sql.ast.query.ConfigurableSubQuery;
import org.babyfish.jimmer.sql.ast.query.TypedSubQuery;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.ast.tuple.Tuple4;
import org.babyfish.jimmer.sql.ast.tuple.Tuple5;
import org.babyfish.jimmer.sql.ast.tuple.Tuple6;
import org.babyfish.jimmer.sql.ast.tuple.Tuple7;
import org.babyfish.jimmer.sql.ast.tuple.Tuple8;
import org.babyfish.jimmer.sql.ast.tuple.Tuple9;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

public class ConfigurableSubQueryImpl<R>
extends AbstractConfigurableTypedQueryImpl
implements ConfigurableSubQuery<R>,
ExpressionImplementor<R> {
    private final Class<R> type;

    ConfigurableSubQueryImpl(TypedQueryData data, MutableSubQueryImpl baseQuery) {
        super(data, baseQuery);
        List<Selection<?>> selections = data.selections;
        switch (selections.size()) {
            case 1: {
                Selection<?> selection = selections.get(0);
                if (selection instanceof Table) {
                    this.type = ((Table)selection).getImmutableType().getJavaClass();
                    break;
                }
                this.type = ((ExpressionImplementor)selection).getType();
                break;
            }
            case 2: {
                this.type = Tuple2.class;
                break;
            }
            case 3: {
                this.type = Tuple3.class;
                break;
            }
            case 4: {
                this.type = Tuple4.class;
                break;
            }
            case 5: {
                this.type = Tuple5.class;
                break;
            }
            case 6: {
                this.type = Tuple6.class;
                break;
            }
            case 7: {
                this.type = Tuple7.class;
                break;
            }
            case 8: {
                this.type = Tuple8.class;
                break;
            }
            case 9: {
                this.type = Tuple9.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("selection count must between 1 and 9");
            }
        }
        baseQuery.freeze();
    }

    @Override
    public Class<R> getType() {
        return this.type;
    }

    @Override
    public MutableSubQueryImpl getBaseQuery() {
        return (MutableSubQueryImpl)super.getBaseQuery();
    }

    @Override
    public ConfigurableSubQuery<R> limit(int limit, int offset) {
        TypedQueryData data = this.getData();
        if (data.limit == limit && data.offset == offset) {
            return this;
        }
        if (limit < 0) {
            throw new IllegalArgumentException("'limit' can not be less than 0");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("'offset' can not be less than 0");
        }
        if (limit > Integer.MAX_VALUE - offset) {
            throw new IllegalArgumentException("'limit' > Int.MAX_VALUE - offset");
        }
        return new ConfigurableSubQueryImpl<R>(data.limit(limit, offset), this.getBaseQuery());
    }

    @Override
    public ConfigurableSubQuery<R> distinct() {
        TypedQueryData data = this.getData();
        if (data.distinct) {
            return this;
        }
        return new ConfigurableSubQueryImpl<R>(data.distinct(), this.getBaseQuery());
    }

    @Override
    public Expression<R> all() {
        return new SubQueryFunctionExpression.All(this);
    }

    @Override
    public Expression<R> any() {
        return new SubQueryFunctionExpression.Any(this);
    }

    @Override
    public Predicate exists() {
        return ExistsPredicate.of(this, false);
    }

    @Override
    public Predicate notExists() {
        return ExistsPredicate.of(this, true);
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        if (visitor.visitSubQuery(this)) {
            this.getBaseQuery().setParent(visitor.getAstContext().getStatement());
            super.accept(visitor);
        }
    }

    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        builder.enter(SqlBuilder.ScopeType.SUB_QUERY);
        super.renderTo(builder);
        builder.leave();
    }

    @Override
    public int precedence() {
        return 0;
    }

    @Override
    public TypedSubQuery<R> union(TypedSubQuery<R> other) {
        return new MergedTypedSubQueryImpl<R>(this.getBaseQuery().getSqlClient(), "union", this, other);
    }

    @Override
    public TypedSubQuery<R> unionAll(TypedSubQuery<R> other) {
        return new MergedTypedSubQueryImpl<R>(this.getBaseQuery().getSqlClient(), "union all", this, other);
    }

    @Override
    public TypedSubQuery<R> minus(TypedSubQuery<R> other) {
        return new MergedTypedSubQueryImpl<R>(this.getBaseQuery().getSqlClient(), "minus", this, other);
    }

    @Override
    public TypedSubQuery<R> intersect(TypedSubQuery<R> other) {
        return new MergedTypedSubQueryImpl<R>(this.getBaseQuery().getSqlClient(), "intersect", this, other);
    }
}

