/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractConfigurableTypedQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractMutableQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.ConfigurableRootQueryImplementor;
import org.babyfish.jimmer.sql.ast.impl.query.MergedTypedRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.TypedQueryData;
import org.babyfish.jimmer.sql.ast.impl.query.UseTableVisitor;
import org.babyfish.jimmer.sql.ast.query.ConfigurableRootQuery;
import org.babyfish.jimmer.sql.ast.query.MutableRootQuery;
import org.babyfish.jimmer.sql.ast.query.Order;
import org.babyfish.jimmer.sql.ast.query.TypedRootQuery;
import org.babyfish.jimmer.sql.ast.query.TypedSubQuery;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.Selectors;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.Nullable;

public class ConfigurableRootQueryImpl<T extends Table<?>, R>
extends AbstractConfigurableTypedQueryImpl
implements ConfigurableRootQuery<T, R>,
ConfigurableRootQueryImplementor<T, R> {
    public ConfigurableRootQueryImpl(TypedQueryData data, MutableRootQueryImpl<T> baseQuery) {
        super(data, baseQuery);
        baseQuery.freeze();
    }

    @Override
    public MutableRootQueryImpl<T> getBaseQuery() {
        return (MutableRootQueryImpl)super.getBaseQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X> ConfigurableRootQuery<T, X> reselect(BiFunction<MutableRootQuery<T>, T, ConfigurableRootQuery<T, X>> block) {
        if (this.getData().oldSelections != null) {
            throw new IllegalStateException("The current query has been reselected, it cannot be reselect again");
        }
        AbstractMutableQueryImpl baseQuery = this.getBaseQuery();
        if (baseQuery.isGroupByClauseUsed()) {
            throw new IllegalStateException("The current query uses group by clause, it cannot be reselected");
        }
        AstContext astContext = new AstContext(baseQuery.getSqlClient());
        ReselectValidator visitor = new ReselectValidator(astContext);
        astContext.pushStatement(baseQuery);
        try {
            for (Selection<?> selection : this.getData().selections) {
                Ast.from(selection, visitor.getAstContext()).accept(visitor);
            }
        }
        finally {
            astContext.popStatement();
        }
        ConfigurableRootQuery<T, X> reselected = block.apply((MutableRootQuery<AbstractMutableQueryImpl>)((Object)baseQuery), (AbstractMutableQueryImpl)baseQuery.getTable());
        List<Selection<?>> selections = ((ConfigurableRootQueryImpl)reselected).getData().selections;
        return new ConfigurableRootQueryImpl<T, R>(this.getData().reselect(selections), baseQuery);
    }

    @Override
    public ConfigurableRootQuery<T, R> distinct() {
        TypedQueryData data = this.getData();
        if (data.distinct) {
            return this;
        }
        return new ConfigurableRootQueryImpl<T, R>(data.distinct(), this.getBaseQuery());
    }

    @Override
    public ConfigurableRootQuery<T, R> limit(int limit, int offset) {
        TypedQueryData data = this.getData();
        if (data.limit == limit && data.offset == offset) {
            return this;
        }
        if (limit < 0) {
            throw new IllegalArgumentException("'limit' can not be less than 0");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("'offset' can not be less than 0");
        }
        if (limit > Integer.MAX_VALUE - offset) {
            throw new IllegalArgumentException("'limit' > Int.MAX_VALUE - offset");
        }
        return new ConfigurableRootQueryImpl<T, R>(data.limit(limit, offset), this.getBaseQuery());
    }

    @Override
    public ConfigurableRootQuery<T, R> withoutSortingAndPaging() {
        TypedQueryData data = this.getData();
        if (data.withoutSortingAndPaging) {
            return this;
        }
        return new ConfigurableRootQueryImpl<T, R>(data.withoutSortingAndPaging(), this.getBaseQuery());
    }

    @Override
    @Nullable
    public ConfigurableRootQuery<T, R> reverseSorting() {
        TypedQueryData data = this.getData();
        if (data.reverseSorting) {
            return this;
        }
        if (this.getBaseQuery().getOrders().isEmpty()) {
            return null;
        }
        return new ConfigurableRootQueryImpl<T, R>(data.reverseSorting(), this.getBaseQuery());
    }

    @Override
    public ConfigurableRootQuery<T, R> forUpdate(boolean forUpdate) {
        if (!forUpdate) {
            return this;
        }
        TypedQueryData data = this.getData();
        return new ConfigurableRootQueryImpl<T, R>(data.forUpdate(), this.getBaseQuery());
    }

    @Override
    public List<R> execute() {
        return this.getBaseQuery().getSqlClient().getSlaveConnectionManager(this.getData().forUpdate).execute(this::executeImpl);
    }

    @Override
    public List<R> execute(Connection con) {
        if (con != null) {
            return this.executeImpl(con);
        }
        return this.getBaseQuery().getSqlClient().getSlaveConnectionManager(this.getData().forUpdate).execute(this::executeImpl);
    }

    private List<R> executeImpl(Connection con) {
        TypedQueryData data = this.getData();
        if (data.limit == 0) {
            return Collections.emptyList();
        }
        JSqlClientImplementor sqlClient = this.getBaseQuery().getSqlClient();
        Tuple3<String, List<Object>, List<Integer>> sqlResult = this.preExecute(new SqlBuilder(new AstContext(sqlClient)));
        return Selectors.select(sqlClient, con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), data.selections, this.getBaseQuery().getPurpose());
    }

    @Override
    public <X> List<X> map(Connection con, Function<R, X> mapper) {
        Object rows = this.execute(con);
        ArrayList<X> mapped = new ArrayList<X>(rows.size());
        Iterator iterator = rows.iterator();
        while (iterator.hasNext()) {
            Object row = iterator.next();
            mapped.add(mapper.apply(row));
        }
        return mapped;
    }

    @Override
    public void forEach(Connection con, int batchSize, Consumer<R> consumer) {
        int finalBatchSize;
        TypedQueryData data = this.getData();
        if (data.limit == 0) {
            return;
        }
        JSqlClientImplementor sqlClient = this.getBaseQuery().getSqlClient();
        int n = finalBatchSize = batchSize > 0 ? batchSize : sqlClient.getDefaultBatchSize();
        if (con != null) {
            this.forEachImpl(con, finalBatchSize, consumer);
        } else {
            sqlClient.getSlaveConnectionManager(this.getData().forUpdate).execute((Connection newConn) -> {
                this.forEachImpl((Connection)newConn, finalBatchSize, consumer);
                return null;
            });
        }
    }

    private void forEachImpl(Connection con, int batchSize, Consumer<R> consumer) {
        JSqlClientImplementor sqlClient = this.getBaseQuery().getSqlClient();
        Tuple3<String, List<Object>, List<Integer>> sqlResult = this.preExecute(new SqlBuilder(new AstContext(sqlClient)));
        Selectors.forEach(sqlClient, con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), this.getData().selections, this.getBaseQuery().getPurpose(), batchSize, consumer);
    }

    private Tuple3<String, List<Object>, List<Integer>> preExecute(SqlBuilder builder) {
        UseTableVisitor visitor = new UseTableVisitor(builder.getAstContext());
        this.accept(visitor);
        this.renderTo(builder);
        return builder.build();
    }

    @Override
    public TypedRootQuery<R> union(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.getBaseQuery().getSqlClient(), "union", this, other);
    }

    @Override
    public TypedRootQuery<R> unionAll(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.getBaseQuery().getSqlClient(), "union all", this, other);
    }

    @Override
    public TypedRootQuery<R> minus(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.getBaseQuery().getSqlClient(), "minus", this, other);
    }

    @Override
    public TypedRootQuery<R> intersect(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.getBaseQuery().getSqlClient(), "intersect", this, other);
    }

    @Override
    public boolean isForUpdate() {
        return this.getData().forUpdate;
    }

    @Override
    public List<Order> getOrders() {
        return this.getBaseQuery().getOrders();
    }

    @Override
    public JSqlClientImplementor getSqlClient() {
        return this.getBaseQuery().getSqlClient();
    }

    private static class ReselectValidator
    extends AstVisitor {
        ReselectValidator(AstContext astContext) {
            super(astContext);
        }

        @Override
        public boolean visitSubQuery(TypedSubQuery<?> subQuery) {
            return false;
        }

        @Override
        public void visitAggregation(String functionName, Expression<?> expression, String prefix) {
            throw new IllegalStateException("The current query uses aggregation function in select clause, it cannot be reselected");
        }
    }
}

