/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.UUID;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.runtime.DbNull;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.jetbrains.annotations.NotNull;

public class DefaultExecutor
implements Executor {
    public static final DefaultExecutor INSTANCE = new DefaultExecutor();

    DefaultExecutor() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R execute(@NotNull Executor.Args<R> args) {
        String sql = args.sql;
        List<Object> variables = args.variables;
        Dialect dialect = args.sqlClient.getDialect();
        try (PreparedStatement stmt = args.statementFactory != null ? args.statementFactory.preparedStatement(args.con, sql) : args.con.prepareStatement(sql);){
            int size = variables.size();
            for (int index = 0; index < size; ++index) {
                Object variable = variables.get(index);
                if (variable instanceof DbNull) {
                    stmt.setNull(index + 1, this.toJdbcType(((DbNull)variable).getType(), dialect));
                    continue;
                }
                stmt.setObject(index + 1, variable);
            }
            Object r = args.block.apply(stmt);
            return r;
        }
        catch (SQLException ex) {
            throw new ExecutionException("Cannot execute SQL statement: " + sql + ", variables: " + variables, ex);
        }
    }

    private int toJdbcType(Class<?> type, Dialect dialect) {
        if (type == String.class) {
            return 12;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return 16;
        }
        if (type == Character.TYPE || type == Character.class) {
            return 1;
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return -6;
        }
        if (type == Short.TYPE || type == Short.class) {
            return 5;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return 4;
        }
        if (type == Long.TYPE || type == Long.class) {
            return -5;
        }
        if (type == Float.TYPE || type == Float.class) {
            return 6;
        }
        if (type == Double.TYPE || type == Double.class) {
            return 8;
        }
        if (type == BigInteger.class) {
            return -5;
        }
        if (type == BigDecimal.class) {
            return 3;
        }
        if (type == UUID.class) {
            return 12;
        }
        if (type == java.util.Date.class || type == Date.class) {
            return 91;
        }
        if (type == Timestamp.class) {
            return 93;
        }
        if (type == LocalDate.class) {
            return 91;
        }
        if (type == LocalTime.class) {
            return 92;
        }
        if (type == LocalDateTime.class || type == ZonedDateTime.class) {
            return 93;
        }
        if (type == byte[].class) {
            return -2;
        }
        int jdbcType = dialect.resolveUnknownJdbcType(type);
        if (jdbcType != 1111) {
            return jdbcType;
        }
        throw new IllegalArgumentException("Cannot convert the sql type '" + type + "' to java.sql.Types by the current dialect \"" + dialect.getClass().getName() + "\"");
    }
}

