/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.util.Collections;
import java.util.List;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.FetcherSelectionImpl;
import org.babyfish.jimmer.sql.ast.impl.table.TableSelection;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.PropExpressionImplementor;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherSelection;

class TypedQueryData {
    private static final Package TUPLE_PACKAGE = Tuple2.class.getPackage();
    private final List<Selection<?>> selections;
    private final List<Selection<?>> oldSelections;
    private final boolean distinct;
    private final int limit;
    private final int offset;
    private final boolean withoutSortingAndPaging;
    private final boolean forUpdate;
    private PropExpressionImplementor<?> idOnlyExpression;
    private boolean idOnlyExpressionResolved;

    public TypedQueryData(List<Selection<?>> selections) {
        this.selections = TypedQueryData.processSelections(selections);
        this.oldSelections = null;
        this.distinct = false;
        this.limit = Integer.MAX_VALUE;
        this.offset = 0;
        this.withoutSortingAndPaging = false;
        this.forUpdate = false;
    }

    private TypedQueryData(List<Selection<?>> selections, List<Selection<?>> oldSelections, boolean distinct, int limit, int offset, boolean withoutSortingAndPaging, boolean forUpdate) {
        this.selections = selections;
        this.oldSelections = oldSelections;
        this.distinct = distinct;
        this.limit = limit;
        this.offset = offset;
        this.withoutSortingAndPaging = withoutSortingAndPaging;
        this.forUpdate = forUpdate;
    }

    public List<Selection<?>> getSelections() {
        return this.selections;
    }

    public List<Selection<?>> getOldSelections() {
        return this.oldSelections;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isWithoutSortingAndPaging() {
        return this.withoutSortingAndPaging;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public TypedQueryData reselect(List<Selection<?>> selections) {
        return new TypedQueryData(TypedQueryData.processSelections(selections), this.selections, this.distinct, this.limit, this.offset, this.withoutSortingAndPaging, this.forUpdate);
    }

    public TypedQueryData distinct() {
        return new TypedQueryData(this.selections, this.oldSelections, true, this.limit, this.offset, this.withoutSortingAndPaging, this.forUpdate);
    }

    public TypedQueryData limit(int limit, int offset) {
        return new TypedQueryData(this.selections, this.oldSelections, this.distinct, limit, offset, this.withoutSortingAndPaging, this.forUpdate);
    }

    public TypedQueryData withoutSortingAndPaging() {
        return new TypedQueryData(this.selections, this.oldSelections, this.distinct, this.limit, this.offset, true, this.forUpdate);
    }

    public TypedQueryData forUpdate() {
        return new TypedQueryData(this.selections, this.oldSelections, this.distinct, this.limit, this.offset, this.withoutSortingAndPaging, true);
    }

    public PropExpressionImplementor<?> getIdOnlyExpression() {
        if (this.idOnlyExpressionResolved) {
            return this.idOnlyExpression;
        }
        List<Selection<?>> selections = this.selections;
        if (selections.size() == 1) {
            Selection<?> selection = selections.get(0);
            Table table = null;
            if (selection instanceof FetcherSelection) {
                Fetcher<?> fetcher = ((FetcherSelection)selection).getFetcher();
                if (fetcher.getFieldMap().size() > 1) {
                    table = ((FetcherSelectionImpl)selection).getTable();
                }
            } else if (selection instanceof Table) {
                table = (Table)selection;
            }
            if (table != null && table.getImmutableType().getSelectableProps().size() > 1) {
                this.idOnlyExpression = (PropExpressionImplementor)table.get(table.getImmutableType().getIdProp().getName());
            }
        }
        this.idOnlyExpressionResolved = true;
        return this.idOnlyExpression;
    }

    private static List<Selection<?>> processSelections(List<Selection<?>> selections) {
        for (Selection<?> selection : selections) {
            if (selection instanceof ExpressionImplementor) {
                Class type = ((ExpressionImplementor)selection).getType();
                if (!TUPLE_PACKAGE.equals(type.getPackage())) continue;
                throw new IllegalArgumentException("Tuple expression cannot be selected");
            }
            if (!(selection instanceof TableSelection) || !((TableSelection)((Object)selection)).isRemote()) continue;
            throw new IllegalArgumentException("Remote table cannot be selected");
        }
        return Collections.unmodifiableList(selections);
    }
}

