/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.filter.impl;

import java.util.SortedMap;
import java.util.TreeMap;
import org.babyfish.jimmer.impl.util.StaticCache;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.table.Props;
import org.babyfish.jimmer.sql.event.EntityEvent;
import org.babyfish.jimmer.sql.filter.BuiltInFilters;
import org.babyfish.jimmer.sql.filter.CacheableFilter;
import org.babyfish.jimmer.sql.filter.Filter;
import org.babyfish.jimmer.sql.filter.FilterArgs;
import org.babyfish.jimmer.sql.filter.impl.TypeAware;

public class BuiltinFiltersImpl
implements BuiltInFilters {
    private final StaticCache<ImmutableType, Filter<Props>> notDeletedCache = new StaticCache(this::createNotDeleted, true);
    private final StaticCache<ImmutableType, Filter<Props>> alreadyDeletedCache = new StaticCache(this::createAlreadyDeleted, true);

    @Override
    public Filter<Props> getDeclaredNotDeletedFilter(ImmutableType immutableType) {
        return (Filter)this.notDeletedCache.get((Object)immutableType);
    }

    @Override
    public Filter<Props> getDeclaredNotDeletedFilter(Class<?> type) {
        return this.getDeclaredNotDeletedFilter(ImmutableType.get(type));
    }

    @Override
    public Filter<Props> getDeclaredAlreadyDeletedFilter(ImmutableType immutableType) {
        return (Filter)this.alreadyDeletedCache.get((Object)immutableType);
    }

    @Override
    public Filter<Props> getDeclaredAlreadyDeletedFilter(Class<?> type) {
        return this.getDeclaredAlreadyDeletedFilter(ImmutableType.get(type));
    }

    private Filter<Props> createNotDeleted(ImmutableType type) {
        LogicalDeletedInfo info = type.getDeclaredLogicalDeletedInfo();
        if (info == null) {
            return null;
        }
        return info.isMultiViewCacheUsed() ? new NotDeletedCacheableFilter(info) : new NotDeletedFilter(info);
    }

    private Filter<Props> createAlreadyDeleted(ImmutableType type) {
        LogicalDeletedInfo info = type.getDeclaredLogicalDeletedInfo();
        if (info == null) {
            return null;
        }
        return info.isMultiViewCacheUsed() ? new AlreadyDeletedCacheableFilter(info) : new AlreadyDeletedFilter(info);
    }

    private static class NotDeletedCacheableFilter
    extends NotDeletedFilter
    implements CacheableFilter<Props> {
        private NotDeletedCacheableFilter(LogicalDeletedInfo info) {
            super(info);
        }

        @Override
        public SortedMap<String, Object> getParameters() {
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            map.put("logicalDeleted", false);
            return map;
        }

        @Override
        public boolean isAffectedBy(EntityEvent<?> e) {
            return e.getChangedRef(this.info.getProp()) != null;
        }
    }

    private static class NotDeletedFilter
    implements Filter<Props>,
    TypeAware {
        protected final LogicalDeletedInfo info;

        private NotDeletedFilter(LogicalDeletedInfo info) {
            this.info = info;
        }

        @Override
        public Class<?> getFilterType() {
            return this.getClass();
        }

        @Override
        public ImmutableType getImmutableType() {
            return this.info.getProp().getDeclaringType();
        }

        @Override
        public void filter(FilterArgs<Props> args) {
            PropExpression expr = (PropExpression)args.getTable().get(this.info.getProp().getName());
            switch (this.info.getNotDeletedAction()) {
                case NE: {
                    if (this.info.isTwoOptionsOnly()) {
                        args.where(expr.eq(this.info.getRestoredValue()));
                        break;
                    }
                    args.where(expr.ne(this.info.getValue()));
                    break;
                }
                case IS_NOT_NULL: {
                    args.where(expr.isNotNull());
                    break;
                }
                case IS_NULL: {
                    args.where(expr.isNull());
                }
            }
        }
    }

    private static class AlreadyDeletedCacheableFilter
    extends AlreadyDeletedFilter
    implements CacheableFilter<Props> {
        private AlreadyDeletedCacheableFilter(LogicalDeletedInfo info) {
            super(info);
        }

        @Override
        public SortedMap<String, Object> getParameters() {
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            map.put("logicalDeleted", true);
            return map;
        }

        @Override
        public boolean isAffectedBy(EntityEvent<?> e) {
            return e.getChangedRef(this.info.getProp()) != null;
        }
    }

    private static class AlreadyDeletedFilter
    implements Filter<Props>,
    TypeAware {
        protected final LogicalDeletedInfo info;

        private AlreadyDeletedFilter(LogicalDeletedInfo info) {
            this.info = info;
        }

        @Override
        public Class<?> getFilterType() {
            return this.getClass();
        }

        @Override
        public ImmutableType getImmutableType() {
            return this.info.getProp().getDeclaringType();
        }

        @Override
        public void filter(FilterArgs<Props> args) {
            PropExpression expr = (PropExpression)args.getTable().get(this.info.getProp().getName());
            switch (this.info.getNotDeletedAction()) {
                case NE: {
                    args.where(expr.eq(this.info.getValue()));
                    break;
                }
                case IS_NOT_NULL: {
                    args.where(expr.isNull());
                    break;
                }
                case IS_NULL: {
                    args.where(expr.isNotNull());
                }
            }
        }
    }
}

