/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.runtime.ExportedSavePath;

public final class SavePath {
    private final ImmutableType type;
    private final ImmutableProp prop;
    private final SavePath parent;

    private SavePath(ImmutableType type) {
        this.type = Objects.requireNonNull(type, "`type` cannot be null");
        this.prop = null;
        this.parent = null;
    }

    private SavePath(ImmutableProp prop, SavePath parent) {
        if (!prop.isAssociation(TargetLevel.PERSISTENT)) {
            throw new IllegalArgumentException("\"" + prop + "\" is not persistent association property");
        }
        this.type = prop.getTargetType();
        this.prop = prop;
        this.parent = parent;
    }

    public static SavePath root(ImmutableType type) {
        return new SavePath(type);
    }

    public SavePath to(ImmutableProp prop) {
        return new SavePath(prop, this);
    }

    public ImmutableType getType() {
        return this.type;
    }

    public ImmutableProp getProp() {
        return this.prop;
    }

    public SavePath getParent() {
        return this.parent;
    }

    public boolean contains(ImmutableProp prop) {
        if (this.prop == prop) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.contains(prop);
        }
        return false;
    }

    public boolean contains(TypedProp.Association<?, ?> prop) {
        return this.contains(prop.unwrap());
    }

    public boolean contains(ImmutableType type) {
        if (this.type == type) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.contains(type);
        }
        return false;
    }

    public boolean contains(Class<?> type) {
        return this.contains(ImmutableType.get(type));
    }

    public int hashCode() {
        return Objects.hash(this.type, this.prop, this.parent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SavePath other = (SavePath)o;
        return this.type == other.type && Objects.equals(this.prop, other.prop) && Objects.equals(this.parent, other.parent);
    }

    public String toString() {
        if (this.parent == null) {
            return "<root>";
        }
        return this.parent + "." + this.prop.getName();
    }

    public ExportedSavePath export() {
        ArrayList<SavePath> paths = new ArrayList<SavePath>();
        SavePath p = this;
        while (p != null) {
            paths.add(p);
            p = p.parent;
        }
        Collections.reverse(paths);
        int size = paths.size();
        ArrayList<ExportedSavePath.Node> nodes = new ArrayList<ExportedSavePath.Node>(size - 1);
        for (int i = 1; i < size; ++i) {
            nodes.add(new ExportedSavePath.Node(((SavePath)paths.get((int)i)).prop.getName(), ((SavePath)paths.get((int)i)).prop.getTargetType().toString()));
        }
        return new ExportedSavePath(((SavePath)paths.get((int)0)).type.toString(), nodes);
    }

    public static SavePath of(ExportedSavePath path) {
        Class<?> rootType;
        try {
            rootType = Class.forName(path.getRootTypeName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("The root type \"" + path.getRootTypeName() + "\" does not exist");
        }
        return SavePath.of(path, rootType);
    }

    public static SavePath of(ExportedSavePath path, ClassLoader classLoader) {
        Class<?> rootType;
        try {
            rootType = Class.forName(path.getRootTypeName(), true, classLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("The root type \"" + path.getRootTypeName() + "\" does not exist");
        }
        return SavePath.of(path, rootType);
    }

    private static SavePath of(ExportedSavePath path, Class<?> rootType) {
        SavePath savePath = new SavePath(ImmutableType.get(rootType));
        for (ExportedSavePath.Node node : path.getNodes()) {
            ImmutableProp prop = savePath.getType().getProp(node.getProp());
            savePath = savePath.to(prop);
        }
        return savePath;
    }
}

