/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractPredicate;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.Literals;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

abstract class ComparisonPredicate
extends AbstractPredicate {
    protected Expression<?> left;
    protected Expression<?> right;

    public ComparisonPredicate(Expression<?> left, Expression<?> right) {
        this.left = left;
        this.right = right;
        Literals.bind(left, right);
        Literals.bind(right, left);
    }

    protected abstract String operator();

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        ((Ast)((Object)this.left)).accept(visitor);
        ((Ast)((Object)this.right)).accept(visitor);
    }

    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        this.renderChild((Ast)((Object)this.left), builder);
        builder.sql(" ");
        builder.sql(this.operator());
        builder.sql(" ");
        this.renderChild((Ast)((Object)this.right), builder);
    }

    @Override
    public int precedence() {
        return 4;
    }

    static class Ge
    extends ComparisonPredicate {
        public Ge(Expression<?> left, Expression<?> right) {
            super(left, right);
        }

        @Override
        protected String operator() {
            return ">=";
        }

        @Override
        public Predicate not() {
            return new Lt(this.left, this.right);
        }
    }

    static class Gt
    extends ComparisonPredicate {
        public Gt(Expression<?> left, Expression<?> right) {
            super(left, right);
        }

        @Override
        protected String operator() {
            return ">";
        }

        @Override
        public Predicate not() {
            return new Le(this.left, this.right);
        }
    }

    static class Le
    extends ComparisonPredicate {
        public Le(Expression<?> left, Expression<?> right) {
            super(left, right);
        }

        @Override
        protected String operator() {
            return "<=";
        }

        @Override
        public Predicate not() {
            return new Gt(this.left, this.right);
        }
    }

    static class Lt
    extends ComparisonPredicate {
        public Lt(Expression<?> left, Expression<?> right) {
            super(left, right);
        }

        @Override
        protected String operator() {
            return "<";
        }

        @Override
        public Predicate not() {
            return new Ge(this.left, this.right);
        }
    }

    static class Ne
    extends ComparisonPredicate {
        public Ne(Expression<?> left, Expression<?> right) {
            super(left, right);
        }

        @Override
        protected String operator() {
            return "<>";
        }

        @Override
        public Predicate not() {
            return new Eq(this.left, this.right);
        }
    }

    static class Eq
    extends ComparisonPredicate {
        public Eq(Expression<?> left, Expression<?> right) {
            super(left, right);
        }

        @Override
        protected String operator() {
            return "=";
        }

        @Override
        public Predicate not() {
            return new Ne(this.left, this.right);
        }
    }
}

