/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.Associations;
import org.babyfish.jimmer.sql.DefaultScalarProvider;
import org.babyfish.jimmer.sql.DraftInterceptor;
import org.babyfish.jimmer.sql.DraftInterceptorManager;
import org.babyfish.jimmer.sql.Entities;
import org.babyfish.jimmer.sql.EnumType;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.TransientResolver;
import org.babyfish.jimmer.sql.TransientResolverManager;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.impl.EntitiesImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.AssociationsImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutableDeleteImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutableUpdateImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MutableSubQueryImpl;
import org.babyfish.jimmer.sql.ast.mutation.MutableDelete;
import org.babyfish.jimmer.sql.ast.mutation.MutableUpdate;
import org.babyfish.jimmer.sql.ast.query.MutableRootQuery;
import org.babyfish.jimmer.sql.ast.query.MutableSubQuery;
import org.babyfish.jimmer.sql.ast.table.AssociationTable;
import org.babyfish.jimmer.sql.ast.table.Props;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.cache.CacheConfig;
import org.babyfish.jimmer.sql.cache.CacheDisableConfig;
import org.babyfish.jimmer.sql.cache.Caches;
import org.babyfish.jimmer.sql.cache.CachesImpl;
import org.babyfish.jimmer.sql.dialect.DefaultDialect;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.babyfish.jimmer.sql.event.Triggers;
import org.babyfish.jimmer.sql.event.TriggersImpl;
import org.babyfish.jimmer.sql.event.binlog.BinLog;
import org.babyfish.jimmer.sql.event.binlog.BinLogParser;
import org.babyfish.jimmer.sql.filter.Filter;
import org.babyfish.jimmer.sql.filter.FilterConfig;
import org.babyfish.jimmer.sql.filter.Filters;
import org.babyfish.jimmer.sql.filter.impl.BuiltinFiltersImpl;
import org.babyfish.jimmer.sql.filter.impl.FilterManager;
import org.babyfish.jimmer.sql.loader.graphql.Loaders;
import org.babyfish.jimmer.sql.loader.graphql.impl.LoadersImpl;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.runtime.ConnectionManager;
import org.babyfish.jimmer.sql.runtime.DefaultExecutor;
import org.babyfish.jimmer.sql.runtime.DefaultTransientResolverProvider;
import org.babyfish.jimmer.sql.runtime.EntityManager;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.Reader;
import org.babyfish.jimmer.sql.runtime.ReaderManager;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;
import org.babyfish.jimmer.sql.runtime.TransientResolverProvider;

class JSqlClientImpl
implements JSqlClient {
    private final ConnectionManager connectionManager;
    private final ConnectionManager slaveConnectionManager;
    private final Dialect dialect;
    private final Executor executor;
    private final Map<Class<?>, ScalarProvider<?, ?>> scalarProviderMap;
    private final Map<ImmutableProp, ScalarProvider<?, ?>> propScalarProviderMap;
    private final Map<Class<?>, IdGenerator> idGeneratorMap;
    private final DefaultScalarProvider defaultScalarProvider;
    private final int defaultBatchSize;
    private final int defaultListBatchSize;
    private final EntitiesImpl entities;
    private final EntityManager entityManager;
    private final Caches caches;
    private final Triggers triggers;
    private final Triggers transactionTriggers;
    private final BinLog binLog;
    private final TransientResolverManager transientResolverManager;
    private final FilterManager filterManager;
    private final DraftInterceptorManager draftInterceptorManager;
    private final Loaders loaders = new LoadersImpl(this);
    private final ReaderManager readerManager = new ReaderManager(this);

    private JSqlClientImpl(ConnectionManager connectionManager, ConnectionManager slaveConnectionManager, Dialect dialect, Executor executor, Map<Class<?>, ScalarProvider<?, ?>> scalarProviderMap, Map<ImmutableProp, ScalarProvider<?, ?>> propScalarProviderMap, Map<Class<?>, IdGenerator> idGeneratorMap, DefaultScalarProvider defaultScalarProvider, int defaultBatchSize, int defaultListBatchSize, EntitiesImpl entities, EntityManager entityManager, Caches caches, Triggers triggers, Triggers transactionTriggers, BinLog binLog, FilterManager filterManager, TransientResolverManager transientResolverManager, DraftInterceptorManager draftInterceptorManager) {
        this.connectionManager = connectionManager != null ? connectionManager : ConnectionManager.ILLEGAL;
        this.slaveConnectionManager = slaveConnectionManager;
        this.dialect = dialect != null ? dialect : new DefaultDialect();
        this.executor = executor != null ? executor : DefaultExecutor.INSTANCE;
        this.scalarProviderMap = scalarProviderMap;
        this.propScalarProviderMap = propScalarProviderMap;
        this.idGeneratorMap = idGeneratorMap;
        this.defaultScalarProvider = defaultScalarProvider;
        this.defaultBatchSize = defaultBatchSize;
        this.defaultListBatchSize = defaultListBatchSize;
        this.entities = entities != null ? entities.forSqlClient(this) : new EntitiesImpl(this);
        this.entityManager = entityManager;
        this.caches = caches != null ? caches : CachesImpl.of(triggers, entityManager, null);
        this.triggers = triggers;
        this.transactionTriggers = transactionTriggers;
        this.binLog = binLog;
        this.filterManager = filterManager;
        this.transientResolverManager = transientResolverManager;
        this.draftInterceptorManager = draftInterceptorManager;
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public ConnectionManager getSlaveConnectionManager(boolean forUpdate) {
        ConnectionManager slave = this.slaveConnectionManager;
        if (slave != null && !forUpdate) {
            return slave;
        }
        return this.connectionManager;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public <T, S> ScalarProvider<T, S> getScalarProvider(Class<T> scalarType) {
        ScalarProvider<?, ?> provider = this.scalarProviderMap.get(scalarType);
        return provider != null ? provider : this.defaultScalarProvider.getProvider(scalarType);
    }

    @Override
    public <T, S> ScalarProvider<T, S> getScalarProvider(ImmutableProp prop) {
        ScalarProvider<?, ?> provider = this.propScalarProviderMap.get(prop);
        if (provider != null) {
            return provider;
        }
        if (prop.isScalar(TargetLevel.ENTITY)) {
            return this.getScalarProvider(prop.getElementClass());
        }
        return null;
    }

    @Override
    public IdGenerator getIdGenerator(Class<?> entityType) {
        IdGenerator userIdGenerator = this.idGeneratorMap.get(entityType);
        if (userIdGenerator == null && (userIdGenerator = this.idGeneratorMap.get(null)) == null) {
            userIdGenerator = ImmutableType.get(entityType).getIdGenerator();
        }
        return userIdGenerator;
    }

    @Override
    public int getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    @Override
    public int getDefaultListBatchSize() {
        return this.defaultListBatchSize;
    }

    @Override
    public <T extends TableProxy<?>> MutableRootQuery<T> createQuery(T table) {
        if (table instanceof TableEx) {
            throw new IllegalArgumentException("Top-level query does not support TableEx");
        }
        return new MutableRootQueryImpl((JSqlClient)this, table, ExecutionPurpose.QUERY, false);
    }

    @Override
    public MutableUpdate createUpdate(TableProxy<?> table) {
        return new MutableUpdateImpl((JSqlClient)this, table);
    }

    @Override
    public MutableDelete createDelete(TableProxy<?> table) {
        return new MutableDeleteImpl((JSqlClient)this, table);
    }

    @Override
    public <SE, ST extends Table<SE>, TE, TT extends Table<TE>> MutableRootQuery<AssociationTable<SE, ST, TE, TT>> createAssociationQuery(AssociationTable<SE, ST, TE, TT> table) {
        if (!(table instanceof TableProxy)) {
            throw new IllegalArgumentException("The argument \"table\" must be proxy");
        }
        return new MutableRootQueryImpl<AssociationTable<SE, ST, TE, TT>>((JSqlClient)this, (TableProxy)((Object)table), ExecutionPurpose.QUERY, false);
    }

    @Override
    public MutableSubQuery createSubQuery(TableProxy<?> table) {
        return new MutableSubQueryImpl((JSqlClient)this, table);
    }

    @Override
    public <SE, ST extends TableEx<SE>, TE, TT extends TableEx<TE>> MutableSubQuery createAssociationSubQuery(AssociationTable<SE, ST, TE, TT> table) {
        if (!(table instanceof TableProxy)) {
            throw new IllegalArgumentException("The argument \"table\" must be proxy");
        }
        return new MutableSubQueryImpl((JSqlClient)this, (TableProxy)((Object)table));
    }

    @Override
    public Entities getEntities() {
        return this.entities;
    }

    @Override
    public TriggerType getTriggerType() {
        if (this.transactionTriggers == null) {
            return TriggerType.BINLOG_ONLY;
        }
        if (this.transactionTriggers == this.triggers) {
            return TriggerType.TRANSACTION_ONLY;
        }
        return TriggerType.BOTH;
    }

    @Override
    public Triggers getTriggers() {
        return this.triggers;
    }

    @Override
    public Triggers getTriggers(boolean transaction) {
        if (transaction) {
            Triggers tt = this.transactionTriggers;
            if (tt == null) {
                throw new IllegalStateException("Transaction triggers is not supported by current sql client");
            }
            return tt;
        }
        return this.triggers;
    }

    public Triggers tryGetTransactionTriggers() {
        return this.transactionTriggers;
    }

    @Override
    public BinLog getBinLog() {
        BinLog bl = this.binLog;
        if (bl == null) {
            throw new IllegalStateException("binLog is not supported because the entityManager of sql client is not specified");
        }
        return bl;
    }

    @Override
    public Associations getAssociations(TypedProp.Association<?, ?> prop) {
        return this.getAssociations(prop.unwrap());
    }

    @Override
    public Associations getAssociations(ImmutableProp immutableProp) {
        return this.getAssociations(AssociationType.of(immutableProp));
    }

    @Override
    public Associations getAssociations(AssociationType associationType) {
        return new AssociationsImpl(this, null, associationType);
    }

    @Override
    public Loaders getLoaders() {
        return this.loaders;
    }

    @Override
    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Override
    public Caches getCaches() {
        return this.caches;
    }

    @Override
    public JSqlClient caches(Consumer<CacheDisableConfig> block) {
        if (block == null) {
            throw new IllegalArgumentException("block cannot be null");
        }
        CacheDisableConfig cfg = new CacheDisableConfig();
        block.accept(cfg);
        return new JSqlClientImpl(this.connectionManager, this.slaveConnectionManager, this.dialect, this.executor, this.scalarProviderMap, this.propScalarProviderMap, this.idGeneratorMap, this.defaultScalarProvider, this.defaultBatchSize, this.defaultListBatchSize, this.entities, this.entityManager, new CachesImpl((CachesImpl)this.caches, cfg), this.triggers, this.transactionTriggers, this.binLog, this.filterManager, this.transientResolverManager, this.draftInterceptorManager);
    }

    @Override
    public JSqlClient filters(Consumer<FilterConfig> block) {
        if (block == null) {
            throw new IllegalArgumentException("block cannot be null");
        }
        FilterConfig cfg = new FilterConfig(this.filterManager);
        block.accept(cfg);
        if (cfg.getFilterManager() == this.filterManager) {
            return this;
        }
        return new JSqlClientImpl(this.connectionManager, this.slaveConnectionManager, this.dialect, this.executor, this.scalarProviderMap, this.propScalarProviderMap, this.idGeneratorMap, this.defaultScalarProvider, this.defaultBatchSize, this.defaultListBatchSize, this.entities, this.entityManager, this.caches, this.triggers, this.transactionTriggers, this.binLog, cfg.getFilterManager(), this.transientResolverManager, this.draftInterceptorManager);
    }

    @Override
    public JSqlClient disableSlaveConnectionManager() {
        if (this.slaveConnectionManager == null) {
            return this;
        }
        return new JSqlClientImpl(this.connectionManager, null, this.dialect, this.executor, this.scalarProviderMap, this.propScalarProviderMap, this.idGeneratorMap, this.defaultScalarProvider, this.defaultBatchSize, this.defaultListBatchSize, this.entities, this.entityManager, this.caches, this.triggers, this.transactionTriggers, this.binLog, this.filterManager, this.transientResolverManager, this.draftInterceptorManager);
    }

    @Override
    public TransientResolver<?, ?> getResolver(ImmutableProp prop) {
        return this.transientResolverManager.get(prop);
    }

    @Override
    public Class<? extends TransientResolverProvider> getResolverProviderClass() {
        return this.transientResolverManager.getProviderClass();
    }

    @Override
    public Filters getFilters() {
        return this.filterManager;
    }

    @Override
    public DraftInterceptor<?> getDraftInterceptor(ImmutableType type) {
        return this.draftInterceptorManager.get(type);
    }

    @Override
    public Reader<?> getReader(Class<?> type) {
        return this.readerManager.reader(type);
    }

    @Override
    public Reader<?> getReader(ImmutableType type) {
        return this.readerManager.reader(type);
    }

    @Override
    public Reader<?> getReader(ImmutableProp prop) {
        return this.readerManager.reader(prop);
    }

    public static class BuilderImpl
    implements JSqlClient.Builder {
        private ConnectionManager connectionManager;
        private ConnectionManager slaveConnectionManager;
        private Dialect dialect;
        private Executor executor;
        private TransientResolverProvider transientResolverProvider;
        private final Map<Class<?>, ScalarProvider<?, ?>> scalarProviderMap = new HashMap();
        private final Map<ImmutableProp, ScalarProvider<?, ?>> propScalarProviderMap = new HashMap();
        private final Map<Class<?>, IdGenerator> idGeneratorMap = new HashMap();
        private EnumType.Strategy defaultEnumStrategy = EnumType.Strategy.NAME;
        private int defaultBatchSize = 128;
        private int defaultListBatchSize = 16;
        private EntityManager entityManager;
        private Caches caches;
        private TriggerType triggerType = TriggerType.BINLOG_ONLY;
        private Triggers triggers;
        private Triggers transactionTriggers;
        private final List<Filter<?>> filters = new ArrayList();
        private final Set<Filter<?>> disabledFilters = new HashSet();
        private boolean ignoreBuiltInFilters = false;
        private final List<DraftInterceptor<?>> interceptors = new ArrayList();
        private ObjectMapper binLogObjectMapper;

        @Override
        public JSqlClient.Builder setConnectionManager(ConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
            return this;
        }

        @Override
        public JSqlClient.Builder setSlaveConnectionManager(ConnectionManager connectionManager) {
            this.slaveConnectionManager = connectionManager;
            return this;
        }

        @Override
        public JSqlClient.Builder setDialect(Dialect dialect) {
            this.dialect = dialect;
            return this;
        }

        @Override
        public JSqlClient.Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        @Override
        public JSqlClient.Builder setTransientResolverProvider(TransientResolverProvider transientResolverProvider) {
            this.transientResolverProvider = transientResolverProvider;
            return this;
        }

        @Override
        public JSqlClient.Builder setIdGenerator(IdGenerator idGenerator) {
            return this.setIdGenerator(null, idGenerator);
        }

        @Override
        public JSqlClient.Builder setIdGenerator(Class<?> entityType, IdGenerator idGenerator) {
            this.idGeneratorMap.put(entityType, idGenerator);
            return this;
        }

        @Override
        public JSqlClient.Builder addScalarProvider(ScalarProvider<?, ?> scalarProvider) {
            Collection<ImmutableProp> props = scalarProvider.getHandledProps();
            if (props == null || props.isEmpty()) {
                this.addScalarProviderImpl(null, scalarProvider);
            } else {
                for (ImmutableProp prop : props) {
                    if (prop == null) {
                        throw new IllegalStateException("Each property of returned list of \"" + scalarProvider.getClass().getName() + ".getHandledProps\" cannot be null");
                    }
                    if (!prop.isScalar(TargetLevel.ENTITY) && !prop.isScalarList()) {
                        throw new IllegalStateException("Each property of returned list of \"" + scalarProvider.getClass().getName() + ".getHandledProps\" must be scalar, but \"" + prop + "\" is not");
                    }
                    this.addScalarProviderImpl(prop, scalarProvider);
                }
            }
            return this;
        }

        @Override
        public JSqlClient.Builder addScalarProvider(TypedProp<?, ?> prop, ScalarProvider<?, ?> scalarProvider) {
            if (prop == null) {
                throw new IllegalArgumentException("prop cannot be null");
            }
            this.addScalarProviderImpl(prop.unwrap(), scalarProvider);
            return this;
        }

        @Override
        public JSqlClient.Builder addScalarProvider(ImmutableProp prop, ScalarProvider<?, ?> scalarProvider) {
            if (prop == null) {
                throw new IllegalArgumentException("prop cannot be null");
            }
            this.addScalarProviderImpl(prop, scalarProvider);
            return this;
        }

        private void addScalarProviderImpl(ImmutableProp prop, ScalarProvider<?, ?> scalarProvider) {
            Type scalarType = scalarProvider.getScalarType();
            if (prop == null) {
                if (!(scalarType instanceof Class)) {
                    throw new IllegalStateException("Illegal scalar provider type \"" + scalarProvider.getClass().getName() + "\" its scalar type argument cannot be \"" + scalarType + "\" because it is global scalar provider, please use property-specific scalar provider");
                }
                if (this.scalarProviderMap.containsKey(scalarType)) {
                    throw new IllegalStateException("Cannot set scalar provider for scalar type \"" + scalarType + "\" twice");
                }
                if (((Class)scalarType).isArray() || Iterable.class.isAssignableFrom((Class)scalarType) || Map.class.isAssignableFrom((Class)scalarType)) {
                    throw new IllegalStateException("Illegal scalar provider type \"" + scalarProvider.getClass().getName() + "\" its scalar type argument cannot be array, collection or map, because it is global scalar provider, please use property-specific scalar provider");
                }
                this.scalarProviderMap.put((Class)scalarType, scalarProvider);
            } else {
                if (!prop.isScalar(TargetLevel.ENTITY) && !prop.isScalarList()) {
                    throw new IllegalStateException("Cannot set scalar provider for property type \"" + prop + "\" because the property is not scalar property");
                }
                if (this.propScalarProviderMap.containsKey(prop)) {
                    throw new IllegalStateException("Cannot set scalar provider for property type \"" + prop + "\" twice");
                }
                this.propScalarProviderMap.put(prop, scalarProvider);
            }
        }

        @Override
        public JSqlClient.Builder setDefaultEnumStrategy(EnumType.Strategy strategy) {
            this.defaultEnumStrategy = strategy != null ? strategy : EnumType.Strategy.NAME;
            return this;
        }

        @Override
        public JSqlClient.Builder setDefaultBatchSize(int size) {
            if (size < 1) {
                throw new IllegalStateException("size cannot be less than 1");
            }
            this.defaultBatchSize = size;
            return this;
        }

        @Override
        public JSqlClient.Builder setDefaultListBatchSize(int size) {
            if (size < 1) {
                throw new IllegalStateException("size cannot be less than 1");
            }
            this.defaultListBatchSize = size;
            return this;
        }

        @Override
        public JSqlClient.Builder setEntityManager(EntityManager entityManager) {
            if (this.entityManager != null && this.entityManager != entityManager) {
                throw new IllegalStateException("The EntityManager of SqlBuilder.Builder can only be set once");
            }
            this.entityManager = entityManager;
            return this;
        }

        @Override
        public JSqlClient.Builder setCaches(Consumer<CacheConfig> block) {
            if (this.caches != null) {
                throw new IllegalStateException("caches cannot be set twice");
            }
            this.createTriggersIfNecessary();
            this.caches = CachesImpl.of(this.triggers, this.entityManager, block);
            return this;
        }

        @Override
        public JSqlClient.Builder setTriggerType(TriggerType triggerType) {
            this.triggerType = triggerType != null ? triggerType : TriggerType.BINLOG_ONLY;
            return this;
        }

        @Override
        public JSqlClient.Builder addFilters(Filter<?> ... filters) {
            return this.addFilters(Arrays.asList(filters));
        }

        @Override
        public JSqlClient.Builder addFilters(Collection<Filter<?>> filters) {
            for (Filter<?> filter : filters) {
                if (filter == null) continue;
                this.filters.add(filter);
            }
            return this;
        }

        @Override
        public JSqlClient.Builder addDisabledFilters(Filter<?> ... filters) {
            return this.addDisabledFilters(Arrays.asList(filters));
        }

        @Override
        public JSqlClient.Builder addDisabledFilters(Collection<Filter<?>> filters) {
            for (Filter<?> filter : filters) {
                if (filter == null) continue;
                this.filters.add(filter);
                this.disabledFilters.add(filter);
            }
            return this;
        }

        @Override
        public JSqlClient.Builder ignoreBuiltInFilters() {
            this.ignoreBuiltInFilters = true;
            return this;
        }

        @Override
        public JSqlClient.Builder addDraftInterceptor(DraftInterceptor<?> interceptor) {
            return this.addDraftInterceptors(Collections.singletonList(interceptor));
        }

        @Override
        public JSqlClient.Builder addDraftInterceptors(DraftInterceptor<?> ... interceptors) {
            return this.addDraftInterceptors(Arrays.asList(interceptors));
        }

        @Override
        public JSqlClient.Builder addDraftInterceptors(Collection<DraftInterceptor<?>> interceptors) {
            for (DraftInterceptor<?> interceptor : interceptors) {
                if (interceptor == null) continue;
                this.interceptors.add(interceptor);
            }
            return this;
        }

        @Override
        public JSqlClient.Builder setBinLogObjectMapper(ObjectMapper mapper) {
            this.binLogObjectMapper = mapper;
            return this;
        }

        @Override
        public JSqlClient build() {
            if (this.entityManager == null) {
                throw new IllegalStateException("The `entityManager` of SqlClient has not been configured");
            }
            this.createTriggersIfNecessary();
            FilterManager filterManager = this.createFilterManager();
            BinLogParser binLogParser = new BinLogParser();
            BinLog binLog = new BinLog(this.entityManager, binLogParser, this.triggers);
            TransientResolverManager transientResolverManager = new TransientResolverManager(this.transientResolverProvider != null ? this.transientResolverProvider : DefaultTransientResolverProvider.INSTANCE);
            JSqlClientImpl sqlClient = new JSqlClientImpl(this.connectionManager, this.slaveConnectionManager, this.dialect, this.executor, this.scalarProviderMap, this.propScalarProviderMap, this.idGeneratorMap, new DefaultScalarProvider(this.defaultEnumStrategy), this.defaultBatchSize, this.defaultListBatchSize, null, this.entityManager, this.caches, this.triggers, this.transactionTriggers, binLog, filterManager, transientResolverManager, new DraftInterceptorManager(this.interceptors));
            filterManager.initialize(sqlClient);
            binLogParser.initialize(sqlClient, this.binLogObjectMapper);
            transientResolverManager.initialize(sqlClient);
            return sqlClient;
        }

        private void createTriggersIfNecessary() {
            if (this.triggers == null) {
                switch (this.triggerType) {
                    case TRANSACTION_ONLY: {
                        this.transactionTriggers = this.triggers = new TriggersImpl();
                        break;
                    }
                    case BOTH: {
                        this.triggers = new TriggersImpl();
                        this.transactionTriggers = new TriggersImpl();
                        break;
                    }
                    default: {
                        this.triggers = new TriggersImpl();
                    }
                }
            }
        }

        private FilterManager createFilterManager() {
            BuiltinFiltersImpl builtInFilters = new BuiltinFiltersImpl();
            if (this.ignoreBuiltInFilters) {
                return new FilterManager(builtInFilters, this.filters, this.disabledFilters);
            }
            ArrayList mergedFilters = new ArrayList(this.filters);
            ArrayList mergedDisabledFilters = new ArrayList(this.disabledFilters);
            for (ImmutableType type : this.entityManager.getAllTypes()) {
                Filter<Props> notDeletedFilter = builtInFilters.getDeclaredNotDeletedFilter(type);
                Filter<Props> alreadyDeletedFilter = builtInFilters.getDeclaredAlreadyDeletedFilter(type);
                if (notDeletedFilter != null) {
                    mergedFilters.add(notDeletedFilter);
                }
                if (alreadyDeletedFilter == null) continue;
                mergedFilters.add(alreadyDeletedFilter);
                mergedDisabledFilters.add(alreadyDeletedFilter);
            }
            return new FilterManager(builtInFilters, mergedFilters, mergedDisabledFilters);
        }
    }
}

