/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.lang.reflect.TypeVariable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.sql.runtime.EnumProviderBuilder;

public abstract class ScalarProvider<T, S> {
    private final Class<T> scalarType;
    private final Class<S> sqlType;
    public static final ScalarProvider<UUID, byte[]> UUID_BY_BYTE_ARRAY = new ScalarProvider<UUID, byte[]>(){

        @Override
        public UUID toScalar(byte[] sqlValue) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(sqlValue);
            long high = byteBuffer.getLong();
            long low = byteBuffer.getLong();
            return new UUID(high, low);
        }

        @Override
        public byte[] toSql(UUID scalarValue) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
            byteBuffer.putLong(scalarValue.getMostSignificantBits());
            byteBuffer.putLong(scalarValue.getLeastSignificantBits());
            return byteBuffer.array();
        }
    };
    public static final ScalarProvider<UUID, String> UUID_BY_STRING = new ScalarProvider<UUID, String>(){

        @Override
        public UUID toScalar(String sqlValue) {
            return UUID.fromString(sqlValue);
        }

        @Override
        public String toSql(UUID scalarValue) {
            return scalarValue.toString();
        }
    };

    public ScalarProvider(Class<T> scalarType, Class<S> sqlType) {
        this.scalarType = scalarType;
        this.sqlType = sqlType;
    }

    protected ScalarProvider() {
        Map argMap = TypeUtils.getTypeArguments(this.getClass(), ScalarProvider.class);
        TypeVariable<Class<T>>[] params = ScalarProvider.class.getTypeParameters();
        this.scalarType = (Class)argMap.get(params[0]);
        this.sqlType = (Class)argMap.get(params[1]);
    }

    public final Class<T> getScalarType() {
        return this.scalarType;
    }

    public final Class<S> getSqlType() {
        return this.sqlType;
    }

    public abstract T toScalar(S var1);

    public abstract S toSql(T var1);

    public static <E extends Enum<E>> ScalarProvider<E, String> enumProviderByString(Class<E> enumType) {
        return ScalarProvider.enumProviderByString(enumType, null);
    }

    public static <E extends Enum<E>> ScalarProvider<E, String> enumProviderByString(Class<E> enumType, Consumer<EnumProviderBuilder<E, String>> block) {
        EnumProviderBuilder<Enum, String> builder = EnumProviderBuilder.of(enumType, String.class, Enum::name);
        if (block != null) {
            block.accept(builder);
        }
        return builder.build();
    }

    public static <E extends Enum<E>> ScalarProvider<E, Integer> enumProviderByInt(Class<E> enumType) {
        return ScalarProvider.enumProviderByInt(enumType, null);
    }

    public static <E extends Enum<E>> ScalarProvider<E, Integer> enumProviderByInt(Class<E> enumType, Consumer<EnumProviderBuilder<E, Integer>> block) {
        EnumProviderBuilder<Enum, Integer> builder = EnumProviderBuilder.of(enumType, Integer.class, Enum::ordinal);
        if (block != null) {
            block.accept(builder);
        }
        return builder.build();
    }
}

