/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;

public final class SavePath {
    private final ImmutableType type;
    private final ImmutableProp prop;
    private final SavePath parent;

    private SavePath(ImmutableType type) {
        this.type = Objects.requireNonNull(type, "`type` cannot be null");
        this.prop = null;
        this.parent = null;
    }

    private SavePath(ImmutableProp prop, SavePath parent) {
        if (!prop.isAssociation(TargetLevel.PERSISTENT)) {
            throw new IllegalArgumentException("\"" + prop + "\" is not persistent association property");
        }
        this.type = prop.getTargetType();
        this.prop = prop;
        this.parent = parent;
    }

    public static SavePath root(ImmutableType type) {
        return new SavePath(type);
    }

    public SavePath to(ImmutableProp prop) {
        return new SavePath(prop, this);
    }

    public ImmutableType getType() {
        return this.type;
    }

    public ImmutableProp getProp() {
        return this.prop;
    }

    public SavePath getParent() {
        return this.parent;
    }

    public boolean contains(ImmutableProp prop) {
        if (this.prop == prop) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.contains(prop);
        }
        return false;
    }

    public boolean contains(TypedProp.Association<?, ?> prop) {
        return this.contains(prop.unwrap());
    }

    public boolean contains(ImmutableType type) {
        if (this.type == type) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.contains(type);
        }
        return false;
    }

    public boolean contains(Class<?> type) {
        return this.contains(ImmutableType.get(type));
    }

    public int hashCode() {
        return Objects.hash(this.type, this.prop, this.parent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SavePath other = (SavePath)o;
        return this.type == other.type && Objects.equals(this.prop, other.prop) && Objects.equals(this.parent, other.parent);
    }

    public String toString() {
        if (this.parent == null) {
            return "<root>";
        }
        return this.parent + "." + this.prop.getName();
    }
}

