/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.loader.graphql.impl;

import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.Executable;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.fetcher.FieldFilter;
import org.babyfish.jimmer.sql.loader.graphql.impl.DataLoader;

class BatchCommand<S, T>
implements Executable<Map<S, T>> {
    private final JSqlClient sqlClient;
    private final Connection con;
    private final ImmutableProp prop;
    private final FieldFilter<Table<ImmutableSpi>> filter;
    private final Collection<ImmutableSpi> sources;
    private final T defaultValue;

    public BatchCommand(JSqlClient sqlClient, Connection con, ImmutableProp prop, FieldFilter<Table<ImmutableSpi>> filter, Collection<ImmutableSpi> sources, T defaultValue) {
        this.sqlClient = sqlClient;
        this.con = con;
        this.prop = prop;
        this.filter = filter;
        this.sources = sources;
        this.defaultValue = defaultValue;
    }

    @Override
    public Map<S, T> execute() {
        if (this.con != null) {
            return this.executeImpl(this.con);
        }
        return this.sqlClient.getConnectionManager().execute(this::executeImpl);
    }

    @Override
    public Map<S, T> execute(Connection con) {
        if (con != null) {
            return this.executeImpl(con);
        }
        if (this.con != null) {
            return this.executeImpl(this.con);
        }
        return this.sqlClient.getConnectionManager().execute(this::executeImpl);
    }

    private Map<S, T> executeImpl(Connection con) {
        Map<ImmutableSpi, Object> resultMap = new DataLoader(this.sqlClient, con, this.prop, this.filter).load(this.sources);
        if (this.defaultValue == null || resultMap.size() == this.sources.size()) {
            return resultMap;
        }
        if (!(resultMap instanceof HashMap)) {
            resultMap = new LinkedHashMap<ImmutableSpi, Object>(resultMap);
        }
        for (ImmutableSpi source : this.sources) {
            resultMap.putIfAbsent(source, this.defaultValue);
        }
        return resultMap;
    }
}

