/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.chain;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheEnvironment;
import org.babyfish.jimmer.sql.cache.CacheLoader;
import org.babyfish.jimmer.sql.cache.chain.CacheChain;
import org.babyfish.jimmer.sql.cache.chain.ChainCacheImpl;
import org.babyfish.jimmer.sql.cache.chain.LoadingBinder;
import org.babyfish.jimmer.sql.cache.chain.SimpleBinder;
import org.jetbrains.annotations.NotNull;

class ParameterizedChainCacheImpl<K, V>
extends ChainCacheImpl<K, V>
implements Cache.Parameterized<K, V> {
    public ParameterizedChainCacheImpl(List<Object> binders) {
        super(binders);
        boolean hasParameterizedBinder = false;
        for (Object binder : binders) {
            boolean isParameterizedBinder;
            boolean bl = isParameterizedBinder = binder instanceof LoadingBinder.Parameterized || binder instanceof SimpleBinder.Parameterized;
            if (hasParameterizedBinder && !isParameterizedBinder) {
                throw new IllegalArgumentException("Parameterized binder must be after other binders");
            }
            hasParameterizedBinder = isParameterizedBinder;
        }
        if (!hasParameterizedBinder) {
            throw new IllegalArgumentException("No parameterized binders");
        }
    }

    @Override
    @NotNull
    public Map<K, V> getAll(@NotNull Collection<K> keys, @NotNull SortedMap<String, Object> parameterMap, @NotNull CacheEnvironment<K, V> env) {
        return ParameterizedChainCacheImpl.usingCacheLoading(env.getLoader(), () -> ((ParameterizedNode)this.node).loadAll(keys, parameterMap));
    }

    @Override
    protected ChainCacheImpl.Node<K, V> createNode(Object binder, ChainCacheImpl.Node<K, V> next) {
        if (binder instanceof LoadingBinder.Parameterized) {
            return new ParameterizedLoadingNode((LoadingBinder.Parameterized)binder, (ParameterizedNode)next);
        }
        if (binder instanceof SimpleBinder.Parameterized) {
            return new ParameterizedSimpleNode<K, V>((SimpleBinder.Parameterized)binder, next);
        }
        return super.createNode(binder, next);
    }

    @Override
    protected TailNode<K, V> createTailNode() {
        return new TailNode();
    }

    private static class ParameterizedLoadingNode<K, V>
    implements ParameterizedNode<K, V> {
        private final LoadingBinder.Parameterized<K, V> binder;
        private final ParameterizedNode<K, V> next;

        ParameterizedLoadingNode(LoadingBinder.Parameterized<K, V> binder, ParameterizedNode<K, V> next) {
            this.binder = binder;
            this.next = next;
            binder.initialize(next);
        }

        @Override
        @NotNull
        public Map<K, V> loadAll(@NotNull Collection<K> keys) {
            return this.binder.getAll(keys);
        }

        @Override
        @NotNull
        public Map<K, V> loadAll(@NotNull Collection<K> keys, @NotNull SortedMap<String, Object> parameterMap) {
            return this.binder.getAll(keys, parameterMap);
        }

        @Override
        public void deleteAll(@NotNull Collection<K> keys, Object reason) {
            this.next.deleteAll(keys, reason);
            this.binder.deleteAll(keys, reason);
        }
    }

    protected static interface ParameterizedNode<K, V>
    extends ChainCacheImpl.Node<K, V>,
    CacheChain.Parameterized<K, V> {
    }

    protected static class ParameterizedSimpleNode<K, V>
    extends ChainCacheImpl.SimpleNode<K, V>
    implements ParameterizedNode<K, V> {
        protected ParameterizedSimpleNode(SimpleBinder.Parameterized<K, V> binder, ChainCacheImpl.Node<K, V> next) {
            super(binder, next);
        }

        @Override
        @NotNull
        public Map<K, V> loadAll(@NotNull Collection<K> keys, @NotNull SortedMap<String, Object> parameterMap) {
            SimpleBinder.Parameterized parameterizedBinder = (SimpleBinder.Parameterized)this.binder;
            Map map = parameterizedBinder.getAll(keys, parameterMap);
            if (map.size() < keys.size()) {
                LinkedHashSet<K> missedKeys = new LinkedHashSet<K>();
                for (K key : keys) {
                    if (map.containsKey(key)) continue;
                    missedKeys.add(key);
                }
                Map mapFromNext = this.next.loadAll(missedKeys);
                if (mapFromNext.size() < missedKeys.size()) {
                    mapFromNext = new HashMap(mapFromNext);
                    for (Object missedKey : missedKeys) {
                        if (mapFromNext.containsKey(missedKey)) continue;
                        mapFromNext.put(missedKey, null);
                    }
                }
                parameterizedBinder.setAll(mapFromNext, parameterMap);
                map.putAll(mapFromNext);
            }
            return map;
        }
    }

    private static class TailNode<K, V>
    extends ChainCacheImpl.TailNode<K, V>
    implements ParameterizedNode<K, V> {
        private TailNode() {
        }

        @Override
        @NotNull
        public Map<K, V> loadAll(@NotNull Collection<K> keys, @NotNull SortedMap<String, Object> parameterMap) {
            CacheLoader loader = ChainCacheImpl.currentCacheLoader();
            return loader.loadAll(keys);
        }
    }
}

