/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Collection;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractPredicate;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

class InCollectionPredicate
extends AbstractPredicate {
    private Expression<?> expression;
    private Collection<?> values;
    private boolean negative;

    public InCollectionPredicate(Expression<?> expression, Collection<?> values, boolean negative) {
        this.expression = expression;
        this.values = values;
        this.negative = negative;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        ((Ast)((Object)this.expression)).accept(visitor);
    }

    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        if (this.values.isEmpty()) {
            builder.sql(this.negative ? "1 = 1" : "1 = 0");
        } else {
            this.renderChild((Ast)((Object)this.expression), builder);
            builder.sql(this.negative ? " not in " : " in ");
            builder.sql("(");
            String separator = "";
            for (Object value : this.values) {
                builder.sql(separator);
                builder.variable(value);
                separator = ", ";
            }
            builder.sql(")");
        }
    }

    @Override
    public int precedence() {
        return 0;
    }

    @Override
    public Predicate not() {
        return new InCollectionPredicate(this.expression, this.values, !this.negative);
    }
}

