/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.math.BigDecimal;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.impl.AbstractExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.NumericExpressionImplementor;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

abstract class AggregationExpression<T>
extends AbstractExpression<T> {
    Expression<?> expression;

    public AggregationExpression(Expression<?> expression) {
        this.expression = expression;
    }

    protected abstract String functionName();

    protected String prefix() {
        return null;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        visitor.visitAggregation(this.functionName(), this.expression, this.prefix());
    }

    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        builder.sql(this.functionName());
        builder.sql("(");
        String prefix = this.prefix();
        if (prefix != null) {
            builder.sql(prefix);
            builder.sql(" ");
        }
        this.renderChild((Ast)((Object)this.expression), builder);
        builder.sql(")");
    }

    @Override
    public int precedence() {
        return 0;
    }

    static class Avg
    extends AggregationExpression<BigDecimal>
    implements NumericExpressionImplementor<BigDecimal> {
        public Avg(Expression<? extends Number> expression) {
            super(expression);
        }

        @Override
        protected String functionName() {
            return "avg";
        }

        @Override
        public Class<BigDecimal> getType() {
            return BigDecimal.class;
        }
    }

    static class Max<N extends Number>
    extends AggregationExpression<N>
    implements NumericExpressionImplementor<N> {
        public Max(Expression<?> expression) {
            super(expression);
        }

        @Override
        protected String functionName() {
            return "max";
        }

        @Override
        public Class<N> getType() {
            return ((AbstractExpression)this.expression).getType();
        }
    }

    static class Min<N extends Number>
    extends AggregationExpression<N>
    implements NumericExpressionImplementor<N> {
        public Min(Expression<?> expression) {
            super(expression);
        }

        @Override
        protected String functionName() {
            return "min";
        }

        @Override
        public Class<N> getType() {
            return ((AbstractExpression)this.expression).getType();
        }
    }

    static class Sum<N extends Number>
    extends AggregationExpression<N>
    implements NumericExpressionImplementor<N> {
        public Sum(Expression<?> expression) {
            super(expression);
        }

        @Override
        protected String functionName() {
            return "sum";
        }

        @Override
        public Class<N> getType() {
            return ((AbstractExpression)this.expression).getType();
        }
    }

    static class CountDistinct
    extends Count {
        public CountDistinct(Expression<?> expression) {
            super(expression);
        }

        @Override
        protected String prefix() {
            return "distinct";
        }
    }

    static class Count
    extends AggregationExpression<Long>
    implements NumericExpressionImplementor<Long> {
        public Count(Expression<?> expression) {
            super(expression);
        }

        @Override
        protected String functionName() {
            return "count";
        }

        @Override
        public Class<Long> getType() {
            return Long.class;
        }
    }
}

