/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Consumer;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.FieldConfig;
import org.babyfish.jimmer.sql.fetcher.FieldFilter;
import org.babyfish.jimmer.sql.fetcher.RecursionStrategy;
import org.babyfish.jimmer.sql.fetcher.impl.DefaultRecursionStrategy;
import org.babyfish.jimmer.sql.fetcher.impl.FieldConfigImpl;
import org.babyfish.jimmer.sql.fetcher.impl.FieldImpl;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;

public class FetcherImpl<E>
implements Fetcher<E> {
    private final FetcherImpl<E> prev;
    private final ImmutableType immutableType;
    private final boolean negative;
    private final ImmutableProp prop;
    private final FieldFilter<?> filter;
    private final int batchSize;
    private final int limit;
    private final int offset;
    private final RecursionStrategy<?> recursionStrategy;
    private final FetcherImpl<?> childFetcher;
    private Map<String, Field> fieldMap;
    private Boolean isSimpleFetcher;

    public FetcherImpl(Class<E> javaClass) {
        this(javaClass, null);
    }

    public FetcherImpl(Class<E> javaClass, FetcherImpl<E> base) {
        if (base != null) {
            if (base.getJavaClass() != javaClass) {
                throw new IllegalArgumentException("The owner type of base fetcher must be \"" + javaClass.getName() + "\"");
            }
            this.prev = base.prev;
            this.immutableType = base.immutableType;
            this.negative = base.negative;
            this.prop = base.prop;
            this.filter = base.filter;
            this.batchSize = base.batchSize;
            this.limit = base.limit;
            this.offset = base.offset;
            this.recursionStrategy = base.recursionStrategy;
            this.childFetcher = base.childFetcher;
        } else {
            this.prev = null;
            this.immutableType = ImmutableType.get(javaClass);
            this.negative = false;
            this.prop = this.immutableType.getIdProp();
            this.filter = null;
            this.batchSize = 0;
            this.limit = Integer.MAX_VALUE;
            this.offset = 0;
            this.recursionStrategy = null;
            this.childFetcher = null;
        }
    }

    protected FetcherImpl(FetcherImpl<E> prev, ImmutableProp prop, boolean negative) {
        this.prev = prev;
        this.immutableType = prev.immutableType;
        this.negative = negative;
        this.prop = prop;
        this.filter = null;
        this.batchSize = 0;
        this.limit = Integer.MAX_VALUE;
        this.offset = 0;
        this.recursionStrategy = null;
        this.childFetcher = negative || !prop.isAssociation(TargetLevel.PERSISTENT) ? null : new FetcherImpl<E>(prop.getTargetType().getJavaClass());
    }

    protected FetcherImpl(FetcherImpl<E> prev, ImmutableProp prop, FieldConfig<?, ? extends Table<?>> fieldConfig) {
        this.prev = prev;
        this.immutableType = prev.immutableType;
        this.negative = false;
        this.prop = prop;
        if (fieldConfig != null) {
            FieldConfigImpl loaderImpl = (FieldConfigImpl)fieldConfig;
            this.filter = loaderImpl.getFilter();
            this.batchSize = loaderImpl.getBatchSize();
            this.limit = prop.isReferenceList(TargetLevel.PERSISTENT) ? loaderImpl.getLimit() : Integer.MAX_VALUE;
            this.offset = prop.isAssociation(TargetLevel.PERSISTENT) ? loaderImpl.getOffset() : 0;
            this.recursionStrategy = loaderImpl.getRecursionStrategy();
            this.childFetcher = FetcherImpl.standardChildFetcher(loaderImpl);
        } else {
            this.filter = null;
            this.batchSize = 0;
            this.limit = Integer.MAX_VALUE;
            this.offset = 0;
            this.recursionStrategy = null;
            this.childFetcher = null;
        }
    }

    @Override
    public Class<E> getJavaClass() {
        return this.immutableType.getJavaClass();
    }

    @Override
    public ImmutableType getImmutableType() {
        return this.immutableType;
    }

    @Override
    public Map<String, Field> getFieldMap() {
        Map<String, Field> map = this.fieldMap;
        if (map == null) {
            Object field;
            map = new HashMap<String, Field>();
            LinkedList<String> orderedNames = new LinkedList<String>();
            FetcherImpl<E> fetcher = this;
            while (fetcher != null) {
                String name = fetcher.prop.getName();
                Object object = field = fetcher.negative ? null : new FieldImpl(this.immutableType, fetcher.prop, fetcher.filter, fetcher.batchSize, fetcher.limit, fetcher.offset, fetcher.recursionStrategy, fetcher.childFetcher);
                if (!map.containsKey(name)) {
                    map.putIfAbsent(name, (Field)field);
                    orderedNames.add(0, name);
                }
                fetcher = fetcher.prev;
            }
            LinkedHashMap<String, Field> orderedMap = new LinkedHashMap<String, Field>();
            LinkedList<Field> nonAbstractFormulaFields = new LinkedList<Field>();
            for (String name : orderedNames) {
                Field field2 = map.get(name);
                if (field2 == null) continue;
                orderedMap.put(name, field2);
                ImmutableProp prop = field2.getProp();
                if (!prop.isFormula() || prop.getFormulaTemplate() != null) continue;
                nonAbstractFormulaFields.add(field2);
            }
            while (!nonAbstractFormulaFields.isEmpty()) {
                field = (Field)nonAbstractFormulaFields.remove(0);
                for (ImmutableProp dependencyProp : field.getProp().getDependencies()) {
                    if (orderedMap.containsKey(dependencyProp.getName())) continue;
                    FieldImpl dependencyField = new FieldImpl(this.immutableType, dependencyProp, field.getFilter(), field.getBatchSize(), Integer.MAX_VALUE, 0, null, null);
                    orderedMap.put(dependencyProp.getName(), dependencyField);
                    if (!dependencyProp.isFormula() || dependencyProp.getFormulaTemplate() != null) continue;
                    nonAbstractFormulaFields.add(dependencyField);
                }
            }
            this.fieldMap = map = Collections.unmodifiableMap(orderedMap);
        }
        return map;
    }

    @Override
    public Fetcher<E> allTableFields() {
        FetcherImpl<E> fetcher = this;
        for (ImmutableProp prop : this.immutableType.getSelectableProps().values()) {
            fetcher = fetcher.addImpl(prop, null);
        }
        return fetcher;
    }

    @Override
    public Fetcher<E> allScalarFields() {
        FetcherImpl<E> fetcher = this;
        for (ImmutableProp prop : this.immutableType.getSelectableProps().values()) {
            if (prop.isAssociation(TargetLevel.PERSISTENT)) continue;
            fetcher = fetcher.addImpl(prop, null);
        }
        return fetcher;
    }

    @Override
    public Fetcher<E> add(String prop) {
        ImmutableProp immutableProp = this.immutableType.getProp(prop);
        return this.addImpl(immutableProp, false);
    }

    @Override
    public Fetcher<E> remove(String prop) {
        ImmutableProp immutableProp = this.immutableType.getProp(prop);
        if (immutableProp.isId()) {
            throw new IllegalArgumentException("Id property \"" + immutableProp + "\" cannot be removed");
        }
        return this.addImpl(immutableProp, true);
    }

    @Override
    public Fetcher<E> add(String prop, Fetcher<?> childFetcher) {
        return this.add(prop, childFetcher, null);
    }

    @Override
    public Fetcher<E> add(String prop, Fetcher<?> childFetcher, Consumer<? extends FieldConfig<?, ? extends Table<?>>> loaderBlock) {
        Objects.requireNonNull(prop, "'prop' cannot be null");
        ImmutableProp immutableProp = this.immutableType.getProp(prop);
        if (!immutableProp.isAssociation(TargetLevel.OBJECT)) {
            throw new IllegalArgumentException("Cannot load scalar property \"" + immutableProp + "\" with child fetcher");
        }
        if (childFetcher != null && immutableProp.getTargetType().getJavaClass() != childFetcher.getJavaClass()) {
            throw new IllegalArgumentException("Illegal type of childFetcher");
        }
        FieldConfigImpl loaderImpl = new FieldConfigImpl(immutableProp, (FetcherImpl)childFetcher);
        if (loaderBlock != null) {
            loaderBlock.accept(loaderImpl);
            if (loaderImpl.getLimit() != Integer.MAX_VALUE && loaderImpl.getBatchSize() != 1) {
                throw new IllegalArgumentException("Fetcher field with limit does not support batch load, the batchSize must be set to 1 when limit is set");
            }
        }
        return this.addImpl(immutableProp, loaderImpl);
    }

    private FetcherImpl<E> addImpl(ImmutableProp prop, boolean negative) {
        if (prop.isId()) {
            return this;
        }
        if (prop.isTransient() && !prop.hasTransientResolver()) {
            throw new IllegalArgumentException("Cannot fetch \"" + prop + "\", it is transient property without resolver");
        }
        return this.createChildFetcher(prop, negative);
    }

    private FetcherImpl<E> addImpl(ImmutableProp prop, FieldConfigImpl<?, ? extends Table<?>> loader) {
        if (prop.isId()) {
            return this;
        }
        return this.createChildFetcher(prop, loader);
    }

    public String toString() {
        return this.toString(true);
    }

    String toString(boolean includeTypeName) {
        StringJoiner joiner = new StringJoiner(", ", " { ", " }");
        for (Field field : this.getFieldMap().values()) {
            joiner.add(field.toString());
        }
        if (includeTypeName) {
            return this.getJavaClass().getName() + joiner;
        }
        return joiner.toString();
    }

    @Override
    public boolean isSimpleFetcher() {
        Boolean isSimple = this.isSimpleFetcher;
        if (isSimple == null) {
            isSimple = true;
            for (Field field : this.getFieldMap().values()) {
                if (field.isSimpleField()) continue;
                isSimple = false;
                break;
            }
            this.isSimpleFetcher = isSimple;
        }
        return isSimple;
    }

    protected FetcherImpl<E> createChildFetcher(ImmutableProp prop, boolean negative) {
        return new FetcherImpl<E>(this, prop, negative);
    }

    protected FetcherImpl<E> createChildFetcher(ImmutableProp prop, FieldConfig<?, ? extends Table<?>> fieldConfig) {
        return new FetcherImpl<E>(this, prop, fieldConfig);
    }

    private static FetcherImpl<?> standardChildFetcher(FieldConfigImpl<?, Table<?>> loaderImpl) {
        FetcherImpl childFetcher = loaderImpl.getChildFetcher();
        if (!(loaderImpl.getProp().getStorage() instanceof ColumnDefinition)) {
            return childFetcher;
        }
        RecursionStrategy<?> strategy = loaderImpl.getRecursionStrategy();
        if (strategy == null) {
            return childFetcher;
        }
        if (strategy instanceof DefaultRecursionStrategy && ((DefaultRecursionStrategy)strategy).getDepth() == 1) {
            return childFetcher;
        }
        if (childFetcher == null) {
            childFetcher = new FetcherImpl(loaderImpl.getProp().getElementClass());
        }
        childFetcher = (FetcherImpl)childFetcher.add(loaderImpl.getProp().getName());
        return childFetcher;
    }
}

