/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.meta.Storage;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Selectors;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

class MiddleTableOperator {
    private final JSqlClient sqlClient;
    private final Connection con;
    private final ImmutableProp prop;
    private final MiddleTable middleTable;
    private final Expression<?> sourceIdExpression;
    private final Expression<?> targetIdExpression;
    private final MutationTrigger trigger;

    private MiddleTableOperator(JSqlClient sqlClient, Connection con, ImmutableProp prop, MiddleTable middleTable, MutationTrigger trigger) {
        this.sqlClient = sqlClient;
        this.con = con;
        this.prop = prop;
        this.middleTable = middleTable;
        this.sourceIdExpression = Expression.any().nullValue(prop.getDeclaringType().getIdProp().getElementClass());
        this.targetIdExpression = Expression.any().nullValue(prop.getTargetType().getIdProp().getElementClass());
        this.trigger = trigger;
    }

    public static MiddleTableOperator tryGet(JSqlClient sqlClient, Connection con, ImmutableProp prop, MutationTrigger trigger) {
        Storage storage = prop.getStorage();
        if (storage instanceof MiddleTable) {
            return new MiddleTableOperator(sqlClient, con, prop, (MiddleTable)storage, trigger);
        }
        ImmutableProp mappedBy = prop.getMappedBy();
        if (mappedBy != null && (storage = mappedBy.getStorage()) instanceof MiddleTable) {
            return new MiddleTableOperator(sqlClient, con, prop, ((MiddleTable)storage).getInverse(), trigger);
        }
        return null;
    }

    List<Object> getTargetIds(Object id) {
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.sql("select ").sql(this.middleTable.getTargetColumnDefinition()).sql(" from ").sql(this.middleTable.getTableName()).sql(" where ").sql(null, this.middleTable.getColumnDefinition(), true).sql(" = ").variable(id);
        Tuple2<String, List<Object>> sqlResult = builder.build();
        return Selectors.select(this.sqlClient, this.con, sqlResult.get_1(), sqlResult.get_2(), Collections.singletonList(this.targetIdExpression), ExecutionPurpose.MUTATE);
    }

    private IdPairReader filterReader(IdPairReader reader) {
        if (!reader.isReadable()) {
            return new TupleReader(Collections.emptyList());
        }
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.sql("select ").sql(this.middleTable.getColumnDefinition()).sql(", ").sql(this.middleTable.getTargetColumnDefinition()).sql(" from ").sql(this.middleTable.getTableName()).sql(" where ").enterTuple().sql(this.middleTable.getColumnDefinition()).sql(", ").sql(this.middleTable.getTargetColumnDefinition()).leaveTuple().sql(" in (");
        while (reader.read()) {
            builder.enterTuple().variable(reader.sourceId()).sql(", ").variable(reader.targetId()).leaveTuple();
            if (!reader.isReadable()) continue;
            builder.sql(", ");
        }
        builder.sql(")");
        reader.reset();
        Tuple2<String, List<Object>> sqlResult = builder.build();
        List<Tuple2<Object, Object>> tuples = Selectors.select(this.sqlClient, this.con, sqlResult.get_1(), sqlResult.get_2(), Arrays.asList(this.sourceIdExpression, this.targetIdExpression), ExecutionPurpose.MUTATE);
        return new TupleReader(tuples);
    }

    IdPairReader getIdPairReader(Collection<Object> sourceIds) {
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.sql("select ").sql(this.middleTable.getColumnDefinition()).sql(", ").sql(this.middleTable.getTargetColumnDefinition()).sql(" from ").sql(this.middleTable.getTableName()).sql(" where ").sql(null, this.middleTable.getColumnDefinition(), true).sql(" in (");
        boolean addComma = false;
        for (Object sourceId : sourceIds) {
            if (addComma) {
                builder.sql(", ");
            } else {
                addComma = true;
            }
            builder.variable(sourceId);
        }
        builder.sql(")");
        Tuple2<String, List<Object>> sqlResult = builder.build();
        List<Tuple2<Object, Object>> tuples = Selectors.select(this.sqlClient, this.con, sqlResult.get_1(), sqlResult.get_2(), Arrays.asList(this.sourceIdExpression, this.targetIdExpression), ExecutionPurpose.MUTATE);
        return new TupleReader(tuples);
    }

    int addTargetIds(Object sourceId, Collection<Object> targetIds) {
        if (targetIds.isEmpty()) {
            return 0;
        }
        Set<Object> set = targetIds instanceof Set ? (Set<Object>)targetIds : new LinkedHashSet<Object>(targetIds);
        return this.add(new OneToManyReader(sourceId, (Collection<Object>)set));
    }

    int add(IdPairReader reader) {
        if (!reader.isReadable()) {
            return 0;
        }
        this.tryPrepareEvent(true, reader);
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.sql("insert into ").sql(this.middleTable.getTableName()).sql("(").sql(this.middleTable.getColumnDefinition()).sql(", ").sql(this.middleTable.getTargetColumnDefinition()).sql(") values ");
        String separator = "";
        while (reader.read()) {
            builder.sql(separator);
            separator = ", ";
            builder.enterTuple().variable(reader.sourceId()).sql(", ").variable(reader.targetId()).leaveTuple();
        }
        Tuple2<String, List<Object>> sqlResult = builder.build();
        return this.sqlClient.getExecutor().execute(this.con, sqlResult.get_1(), sqlResult.get_2(), ExecutionPurpose.MUTATE, null, PreparedStatement::executeUpdate);
    }

    int removeTargetIds(Object sourceId, Collection<Object> targetIds) {
        if (targetIds.isEmpty()) {
            return 0;
        }
        Set<Object> set = targetIds instanceof Set ? (Set<Object>)targetIds : new LinkedHashSet<Object>(targetIds);
        return this.remove(new OneToManyReader(sourceId, (Collection<Object>)set));
    }

    int remove(IdPairReader reader) {
        return this.remove(reader, false);
    }

    int remove(IdPairReader reader, boolean checkExistence) {
        if (!reader.isReadable()) {
            return 0;
        }
        if (checkExistence && !(reader = this.filterReader(reader)).isReadable()) {
            return 0;
        }
        this.tryPrepareEvent(false, reader);
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.sql("delete from ").sql(this.middleTable.getTableName()).sql(" where ").enterTuple().sql(this.middleTable.getColumnDefinition()).sql(", ").sql(this.middleTable.getTargetColumnDefinition()).leaveTuple().sql(" in (");
        String separator = "";
        while (reader.read()) {
            builder.sql(separator);
            separator = ", ";
            builder.enterTuple().variable(reader.sourceId()).sql(", ").variable(reader.targetId()).leaveTuple();
        }
        builder.sql(")");
        Tuple2<String, List<Object>> sqlResult = builder.build();
        return this.sqlClient.getExecutor().execute(this.con, sqlResult.get_1(), sqlResult.get_2(), ExecutionPurpose.MUTATE, null, PreparedStatement::executeUpdate);
    }

    int setTargetIds(Object sourceId, Collection<Object> targetIds) {
        LinkedHashSet<Object> oldTargetIds = new LinkedHashSet<Object>(this.getTargetIds(sourceId));
        LinkedHashSet<Object> addingTargetIds = new LinkedHashSet<Object>(targetIds);
        addingTargetIds.removeAll(oldTargetIds);
        LinkedHashSet<Object> removingTargetIds = new LinkedHashSet<Object>(oldTargetIds);
        removingTargetIds.removeAll(targetIds);
        return this.removeTargetIds(sourceId, removingTargetIds) + this.addTargetIds(sourceId, addingTargetIds);
    }

    public int removeBySourceIds(Collection<Object> sourceIds) {
        if (this.trigger != null) {
            IdPairReader reader = this.getIdPairReader(sourceIds);
            return this.remove(reader);
        }
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.sql("delete from ");
        builder.sql(this.middleTable.getTableName());
        builder.sql(" where ");
        builder.sql(null, this.middleTable.getColumnDefinition(), true);
        builder.sql(" in (");
        String separator = "";
        for (Object id : sourceIds) {
            builder.sql(separator);
            separator = ", ";
            builder.variable(id);
        }
        builder.sql(")");
        Tuple2<String, List<Object>> sqlResult = builder.build();
        return this.sqlClient.getExecutor().execute(this.con, sqlResult.get_1(), sqlResult.get_2(), ExecutionPurpose.DELETE, null, PreparedStatement::executeUpdate);
    }

    private void tryPrepareEvent(boolean insert, IdPairReader reader) {
        MutationTrigger trigger = this.trigger;
        if (trigger == null) {
            return;
        }
        while (reader.read()) {
            Object sourceId = reader.sourceId();
            Object targetId = reader.targetId();
            if (insert) {
                trigger.insertMiddleTable(this.prop, sourceId, targetId);
                continue;
            }
            trigger.deleteMiddleTable(this.prop, sourceId, targetId);
        }
        reader.reset();
    }

    static interface IdPairReader {
        public void reset();

        public boolean read();

        public boolean isReadable();

        public Object sourceId();

        public Object targetId();
    }

    public static class TupleReader
    implements IdPairReader {
        private final Collection<Tuple2<Object, Object>> idTuples;
        private Iterator<Tuple2<Object, Object>> idTupleItr;
        private Tuple2<Object, Object> currentIdPair;

        public TupleReader(Collection<Tuple2<Object, Object>> idTuples) {
            this.idTuples = idTuples;
            this.idTupleItr = idTuples.iterator();
        }

        @Override
        public void reset() {
            this.idTupleItr = this.idTuples.iterator();
        }

        @Override
        public boolean read() {
            if (this.idTupleItr.hasNext()) {
                this.currentIdPair = this.idTupleItr.next();
                return true;
            }
            return false;
        }

        @Override
        public boolean isReadable() {
            return this.idTupleItr.hasNext();
        }

        @Override
        public Object sourceId() {
            return this.currentIdPair.get_1();
        }

        @Override
        public Object targetId() {
            return this.currentIdPair.get_2();
        }
    }

    private static class OneToManyReader
    implements IdPairReader {
        private final Object sourceId;
        private final Collection<Object> targetIds;
        private Iterator<Object> targetIdItr;
        private Object currentTargetId;

        OneToManyReader(Object sourceId, Collection<Object> targetIds) {
            this.sourceId = sourceId;
            this.targetIds = targetIds;
            this.targetIdItr = targetIds.iterator();
        }

        @Override
        public void reset() {
            this.targetIdItr = this.targetIds.iterator();
        }

        @Override
        public boolean read() {
            if (this.targetIdItr.hasNext()) {
                this.currentTargetId = this.targetIdItr.next();
                return true;
            }
            return false;
        }

        @Override
        public boolean isReadable() {
            return this.targetIdItr.hasNext();
        }

        @Override
        public Object sourceId() {
            return this.sourceId;
        }

        @Override
        public Object targetId() {
            return this.currentTargetId;
        }
    }
}

