/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.mutation.AbstractEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.babyfish.jimmer.sql.event.Triggers;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;

abstract class AbstractEntitySaveCommandImpl
implements AbstractEntitySaveCommand {
    final JSqlClient sqlClient;
    final Connection con;
    final Data data;

    AbstractEntitySaveCommandImpl(JSqlClient sqlClient, Connection con, Data data) {
        this.sqlClient = sqlClient;
        this.con = con;
        this.data = data != null ? data.freeze() : new Data(sqlClient).freeze();
    }

    @Override
    public AbstractEntitySaveCommand configure(Consumer<AbstractEntitySaveCommand.Cfg> block) {
        Data newData = new Data(this.data);
        block.accept(newData);
        if (newData.mode == SaveMode.UPSERT && newData.keyPropMultiMap.isEmpty() && !newData.autoAttachingAll && newData.dissociateActionMap.isEmpty() && newData.autoAttachingSet.isEmpty()) {
            return this;
        }
        return this.create(newData);
    }

    abstract AbstractEntitySaveCommand create(Data var1);

    static class Data
    implements AbstractEntitySaveCommand.Cfg {
        private final JSqlClient sqlClient;
        private final Triggers triggers;
        private boolean frozen;
        private SaveMode mode;
        private Map<ImmutableType, Set<ImmutableProp>> keyPropMultiMap;
        private boolean autoAttachingAll;
        private Set<ImmutableProp> autoAttachingSet;
        private Map<ImmutableProp, DissociateAction> dissociateActionMap;
        private boolean pessimisticLock;

        Data(JSqlClient sqlClient) {
            this.sqlClient = sqlClient;
            this.triggers = sqlClient.getTriggerType() == TriggerType.BINLOG_ONLY ? null : sqlClient.getTriggers(true);
            this.mode = SaveMode.UPSERT;
            this.keyPropMultiMap = new LinkedHashMap<ImmutableType, Set<ImmutableProp>>();
            this.autoAttachingSet = new LinkedHashSet<ImmutableProp>();
            this.dissociateActionMap = new LinkedHashMap<ImmutableProp, DissociateAction>();
            this.pessimisticLock = false;
        }

        Data(Data base) {
            this.sqlClient = base.sqlClient;
            this.triggers = base.triggers;
            this.mode = SaveMode.UPSERT;
            this.keyPropMultiMap = new LinkedHashMap<ImmutableType, Set<ImmutableProp>>(base.keyPropMultiMap);
            this.autoAttachingAll = base.autoAttachingAll;
            this.autoAttachingSet = new LinkedHashSet<ImmutableProp>(base.autoAttachingSet);
            this.dissociateActionMap = new LinkedHashMap<ImmutableProp, DissociateAction>(base.dissociateActionMap);
            this.pessimisticLock = base.pessimisticLock;
        }

        public JSqlClient getSqlClient() {
            return this.sqlClient;
        }

        public Triggers getTriggers() {
            return this.triggers;
        }

        public SaveMode getMode() {
            return this.mode;
        }

        public Set<ImmutableProp> getKeyProps(ImmutableType type) {
            Set<ImmutableProp> keyProps = this.keyPropMultiMap.get(type);
            if (keyProps != null) {
                return keyProps;
            }
            return type.getKeyProps();
        }

        public boolean isAutoAttachingProp(ImmutableProp prop) {
            return this.autoAttachingAll || this.autoAttachingSet.contains(prop);
        }

        public DissociateAction getDissociateAction(ImmutableProp prop) {
            DissociateAction action = this.dissociateActionMap.get(prop);
            return action != null ? action : prop.getDissociateAction();
        }

        Map<ImmutableProp, DissociateAction> dissociateActionMap() {
            return this.dissociateActionMap;
        }

        boolean isPessimisticLockRequired() {
            return this.pessimisticLock;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setMode(SaveMode mode) {
            this.validate();
            this.mode = Objects.requireNonNull(mode, "mode cannot be null");
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setKeyProps(ImmutableProp ... props) {
            this.validate();
            ImmutableType type = null;
            LinkedHashSet<ImmutableProp> set = new LinkedHashSet<ImmutableProp>();
            for (ImmutableProp prop : props) {
                if (prop == null) continue;
                if (prop.isId()) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is id property");
                }
                if (prop.isVersion()) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is version property");
                }
                if (prop.isAssociation(TargetLevel.PERSISTENT) || !(prop.getStorage() instanceof ColumnDefinition)) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is not a scalar property with storage");
                }
                if (prop.isNullable()) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is nullable");
                }
                if (type == null) {
                    type = prop.getDeclaringType();
                } else if (type != prop.getDeclaringType()) {
                    throw new IllegalArgumentException("all key properties must belong to one type");
                }
                set.add(prop);
            }
            if (type != null) {
                this.keyPropMultiMap.put(type, set);
            }
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setAutoAttachingAll() {
            this.autoAttachingAll = true;
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setAutoAttaching(ImmutableProp prop) {
            this.validate();
            this.autoAttachingSet.add(prop);
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setDissociateAction(ImmutableProp prop, DissociateAction dissociateAction) {
            this.validate();
            if (!prop.isReference(TargetLevel.PERSISTENT) || !(prop.getStorage() instanceof ColumnDefinition)) {
                throw new IllegalArgumentException("'" + prop + "' must be an reference property bases on foreign key");
            }
            if (dissociateAction == DissociateAction.SET_NULL && !prop.isNullable()) {
                throw new IllegalArgumentException("'" + prop + "' is not nullable so that it does not support 'on delete set null'");
            }
            if (dissociateAction == DissociateAction.SET_NULL && prop.isInputNotNull()) {
                throw new IllegalArgumentException("'" + prop + "' is `inputNotNull` so that it does not support 'on delete set null'");
            }
            this.dissociateActionMap.put(prop, dissociateAction);
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setPessimisticLock(boolean pessimisticLock) {
            this.pessimisticLock = pessimisticLock;
            return this;
        }

        public Data freeze() {
            if (!this.frozen) {
                this.keyPropMultiMap = Collections.unmodifiableMap(this.keyPropMultiMap);
                this.autoAttachingSet = Collections.unmodifiableSet(this.autoAttachingSet);
                this.dissociateActionMap = Collections.unmodifiableMap(this.dissociateActionMap);
                this.frozen = true;
            }
            return this;
        }

        private void validate() {
            if (this.frozen) {
                throw new IllegalStateException("The current configuration is frozen");
            }
        }
    }
}

