/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.loader.impl;

import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.ImmutableProps;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.loader.FilterableListLoader;
import org.babyfish.jimmer.sql.loader.FilterableReferenceLoader;
import org.babyfish.jimmer.sql.loader.ListLoader;
import org.babyfish.jimmer.sql.loader.Loaders;
import org.babyfish.jimmer.sql.loader.ReferenceLoader;
import org.babyfish.jimmer.sql.loader.ValueLoader;
import org.babyfish.jimmer.sql.loader.impl.ListLoaderImpl;
import org.babyfish.jimmer.sql.loader.impl.ReferenceLoaderImpl;
import org.babyfish.jimmer.sql.loader.impl.ValueLoaderImpl;

public class LoadersImpl
implements Loaders {
    private final JSqlClient sqlClient;

    public LoadersImpl(JSqlClient sqlClient) {
        this.sqlClient = sqlClient;
    }

    @Override
    public <S, T> ValueLoader<S, T> value(TypedProp.Scalar<S, T> prop) {
        return this.value(prop.unwrap());
    }

    @Override
    public <S, T> ReferenceLoader<S, T> reference(TypedProp.Reference<S, T> prop) {
        return this.reference(prop.unwrap());
    }

    @Override
    public <S, T> ListLoader<S, T> list(TypedProp.ReferenceList<S, T> prop) {
        return this.list(prop.unwrap());
    }

    @Override
    public <SE, ST extends Table<SE>, TE, TT extends Table<TE>> FilterableReferenceLoader<SE, TE, TT> reference(Class<ST> sourceTableType, Function<ST, TT> block) {
        return this.reference(ImmutableProps.join(sourceTableType, block));
    }

    @Override
    public <SE, ST extends Table<SE>, TE, TT extends Table<TE>> FilterableListLoader<SE, TE, TT> list(Class<ST> sourceTableType, Function<ST, TT> block) {
        return this.list(ImmutableProps.join(sourceTableType, block));
    }

    public <S, T> ValueLoader<S, T> value(ImmutableProp prop) {
        if (!prop.hasTransientResolver()) {
            throw new IllegalArgumentException("Cannot create reference loader for \"" + prop + "\", it is not transient property with resolver");
        }
        return new ValueLoaderImpl(this.sqlClient, prop);
    }

    public <SE, TE, TT extends Table<TE>> FilterableReferenceLoader<SE, TE, TT> reference(ImmutableProp prop) {
        if (!prop.isReference(TargetLevel.PERSISTENT)) {
            throw new IllegalArgumentException("Cannot create reference loader for \"" + prop + "\", it is not entity reference association");
        }
        return new ReferenceLoaderImpl(this.sqlClient, prop);
    }

    public <SE, TE, TT extends Table<TE>> FilterableListLoader<SE, TE, TT> list(ImmutableProp prop) {
        if (!prop.isReferenceList(TargetLevel.PERSISTENT)) {
            throw new IllegalArgumentException("Cannot create list loader for \"" + prop + "\", it is not entity list association");
        }
        return new ListLoaderImpl(this.sqlClient, prop);
    }
}

