/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event.binlog;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;

class ValueParser {
    private static final Map<Class<?>, Caster> CASTER_MAP = new CasterMapBuilder().add(Boolean.TYPE, Boolean.class, JsonNode::asBoolean).add(Character.TYPE, Character.class, valueNode -> Character.valueOf(valueNode.asText().charAt(0))).add(Byte.TYPE, Byte.class, valueNode -> (byte)valueNode.asInt()).add(Short.TYPE, Short.class, valueNode -> (short)valueNode.asInt()).add(Integer.TYPE, Integer.class, JsonNode::asInt).add(Long.TYPE, Long.class, JsonNode::asLong).add(Float.TYPE, Float.class, valueNode -> Float.valueOf((float)valueNode.asDouble())).add(Double.TYPE, Double.class, JsonNode::asDouble).add(BigInteger.class, valueNode -> new BigInteger(valueNode.asText())).add(BigDecimal.class, valueNode -> new BigDecimal(valueNode.asText())).add(String.class, JsonNode::asText).add(UUID.class, valueNode -> UUID.fromString(valueNode.asText())).build();
    private static final Object ILLEGAL_VALUE = new Object();
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule());

    private ValueParser() {
    }

    public static void addEntityProp(DraftSpi spi, List<ImmutableProp> chain, JsonNode jsonNode, JSqlClient sqlClient) throws IOException {
        ImmutableProp entityProp = chain.get(0);
        if (entityProp.isEmbedded(EmbeddedLevel.BOTH)) {
            for (ImmutableProp prop : chain) {
                int propId = prop.getId();
                if (prop.getTargetType() != null) {
                    if (!spi.__isLoaded(propId)) {
                        spi.__set(propId, Internal.produce((ImmutableType)prop.getTargetType(), null, null));
                    }
                    spi = (DraftSpi)spi.__get(propId);
                    continue;
                }
                Object value = ValueParser.parseSingleValue(sqlClient, jsonNode, prop.getElementClass(), true);
                if (value == null && !prop.isNullable()) continue;
                spi.__set(propId, value);
            }
        } else {
            ImmutableProp targetIdProp;
            Object valueId;
            Object value = entityProp.isAssociation(TargetLevel.PERSISTENT) ? ((valueId = ValueParser.parseSingleValue(sqlClient, jsonNode, (targetIdProp = entityProp.getTargetType().getIdProp()).getElementClass(), false)) == null ? null : Internal.produce((ImmutableType)entityProp.getTargetType(), null, targetDraft -> ((DraftSpi)targetDraft).__set(targetIdProp.getId(), valueId))) : ValueParser.parseSingleValue(sqlClient, jsonNode, entityProp.getElementClass(), true);
            if (value != ILLEGAL_VALUE) {
                spi.__set(entityProp.getId(), value);
            }
        }
    }

    public static Object parseSingleValue(JSqlClient sqlClient, JsonNode jsonNode, Class<?> javaType, boolean useScalarProvider) {
        Class<Object> sqlType;
        ScalarProvider<?, Object> provider = useScalarProvider ? sqlClient.getScalarProvider(javaType) : null;
        Class<Object> clazz = sqlType = provider != null ? provider.getSqlType() : javaType;
        if (Date.class.isAssignableFrom(sqlType) || Temporal.class.isAssignableFrom(sqlType)) {
            return ILLEGAL_VALUE;
        }
        Object value = ValueParser.valueOf(jsonNode, sqlType);
        if (provider != null && value != null) {
            return provider.toScalar(value);
        }
        return value;
    }

    private static Object valueOf(JsonNode node, Class<?> type) {
        if (node.isNull()) {
            return null;
        }
        Caster caster = CASTER_MAP.get(type);
        if (caster != null) {
            return caster.cast(node);
        }
        try {
            return MAPPER.readValue(node.toString(), type);
        }
        catch (JsonProcessingException ex) {
            return ILLEGAL_VALUE;
        }
    }

    private static interface Caster {
        public Object cast(JsonNode var1);
    }

    private static class CasterMapBuilder {
        private Map<Class<?>, Caster> map = new HashMap();

        private CasterMapBuilder() {
        }

        public CasterMapBuilder add(Class<?> type, Caster caster) {
            this.map.put(type, caster);
            return this;
        }

        public CasterMapBuilder add(Class<?> type1, Class<?> type2, Caster caster) {
            this.map.put(type1, caster);
            this.map.put(type2, caster);
            return this;
        }

        public Map<Class<?>, Caster> build() {
            return this.map;
        }
    }
}

