/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.babyfish.jimmer.jackson.ImmutableModule;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.DraftContext;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.cache.SerializationException;
import org.jetbrains.annotations.NotNull;

public class ValueSerializer<T> {
    private static final byte[] NULL_BYTES = "<null>".getBytes(StandardCharsets.UTF_8);
    private final ObjectMapper mapper;
    private final JavaType valueType;
    private final boolean requireNewDraftContext;

    public ValueSerializer(@NotNull ImmutableType type) {
        this(type, null, null);
    }

    public ValueSerializer(@NotNull ImmutableProp prop) {
        this(null, prop, null);
    }

    public ValueSerializer(@NotNull ImmutableType type, ObjectMapper mapper) {
        this(type, null, mapper);
    }

    public ValueSerializer(@NotNull ImmutableProp prop, ObjectMapper mapper) {
        this(null, prop, mapper);
    }

    private ValueSerializer(ImmutableType type, ImmutableProp prop, ObjectMapper mapper) {
        if (type == null == (prop == null)) {
            throw new IllegalArgumentException("Internal bug: nullity of type and prop must be different");
        }
        ObjectMapper clonedMapper = mapper != null ? new ObjectMapper(mapper){} : new ObjectMapper().registerModule((Module)new JavaTimeModule());
        clonedMapper.registerModule((Module)new ImmutableModule());
        this.mapper = clonedMapper;
        if (prop == null) {
            this.valueType = SimpleType.constructUnsafe((Class)type.getJavaClass());
        } else if (prop.isAssociation(TargetLevel.OBJECT)) {
            ImmutableProp targetIdProp = prop.getTargetType().getIdProp();
            if (targetIdProp == null) {
                throw new IllegalArgumentException("Transient association property is not supported");
            }
            SimpleType targetIdType = SimpleType.constructUnsafe((Class)targetIdProp.getElementClass());
            this.valueType = prop.isReferenceList(TargetLevel.PERSISTENT) ? CollectionType.construct(List.class, null, null, null, (JavaType)targetIdType) : targetIdType;
        } else {
            this.valueType = SimpleType.constructUnsafe((Class)prop.getElementClass());
        }
        this.requireNewDraftContext = type != null;
    }

    @NotNull
    public byte[] serialize(T value) {
        if (value == null) {
            return (byte[])NULL_BYTES.clone();
        }
        try {
            return this.mapper.writeValueAsBytes(value);
        }
        catch (JsonProcessingException ex) {
            throw new SerializationException(ex);
        }
    }

    @NotNull
    public <K> Map<K, byte[]> serialize(@NotNull Map<K, T> map) {
        LinkedHashMap<K, byte[]> serializedMap = new LinkedHashMap<K, byte[]>((map.size() * 4 + 2) / 3);
        for (Map.Entry<K, T> e : map.entrySet()) {
            serializedMap.put(e.getKey(), this.serialize(e.getValue()));
        }
        return serializedMap;
    }

    @NotNull
    public <K1, K2> Map<K2, byte[]> serialize(@NotNull Map<K1, T> map, @NotNull Function<K1, K2> keyMapper) {
        LinkedHashMap<K2, byte[]> serializedMap = new LinkedHashMap<K2, byte[]>((map.size() * 4 + 2) / 3);
        for (Map.Entry<K1, T> e : map.entrySet()) {
            serializedMap.put(keyMapper.apply(e.getKey()), this.serialize(e.getValue()));
        }
        return serializedMap;
    }

    public T deserialize(byte[] value) {
        if (!this.requireNewDraftContext) {
            return this.deserializeImpl(value, null);
        }
        return (T)Internal.requiresNewDraftContext(ctx -> this.deserializeImpl(value, (DraftContext)ctx));
    }

    @NotNull
    public <K> Map<K, T> deserialize(@NotNull Map<K, byte[]> map) {
        LinkedHashMap deserializedMap = new LinkedHashMap((map.size() * 4 + 2) / 3);
        if (!this.requireNewDraftContext) {
            for (Map.Entry<K, byte[]> e : map.entrySet()) {
                deserializedMap.put(e.getKey(), this.deserializeImpl(e.getValue(), null));
            }
        } else {
            Internal.requiresNewDraftContext(ctx -> {
                for (Map.Entry e : map.entrySet()) {
                    deserializedMap.put(e.getKey(), this.deserializeImpl((byte[])e.getValue(), (DraftContext)ctx));
                }
                return null;
            });
        }
        return deserializedMap;
    }

    @NotNull
    public <K1, K2> Map<K2, T> deserialize(@NotNull Map<K1, byte[]> map, @NotNull Function<K1, K2> keyMapper) {
        LinkedHashMap deserializedMap = new LinkedHashMap((map.size() * 4 + 2) / 3);
        if (!this.requireNewDraftContext) {
            for (Map.Entry<K1, byte[]> e : map.entrySet()) {
                deserializedMap.put(keyMapper.apply(e.getKey()), this.deserializeImpl(e.getValue(), null));
            }
        } else {
            Internal.requiresNewDraftContext(ctx -> {
                for (Map.Entry e : map.entrySet()) {
                    deserializedMap.put(keyMapper.apply(e.getKey()), this.deserializeImpl((byte[])e.getValue(), (DraftContext)ctx));
                }
                return null;
            });
        }
        return deserializedMap;
    }

    @NotNull
    public <K> Map<K, T> deserialize(@NotNull Collection<K> keys, @NotNull Collection<byte[]> values) {
        LinkedHashMap deserializedMap = new LinkedHashMap((keys.size() * 4 + 2) / 3);
        if (!this.requireNewDraftContext) {
            Iterator<K> keyItr = keys.iterator();
            Iterator<byte[]> byteArrItr = values.iterator();
            while (keyItr.hasNext() && byteArrItr.hasNext()) {
                K key = keyItr.next();
                byte[] byteArr = byteArrItr.next();
                if (byteArr == null) continue;
                deserializedMap.put(key, this.deserializeImpl(byteArr, null));
            }
        } else {
            Internal.requiresNewDraftContext(ctx -> {
                Iterator keyItr = keys.iterator();
                Iterator byteArrItr = values.iterator();
                while (keyItr.hasNext() && byteArrItr.hasNext()) {
                    Object key = keyItr.next();
                    byte[] byteArr = (byte[])byteArrItr.next();
                    if (byteArr == null) continue;
                    deserializedMap.put(key, this.deserializeImpl(byteArr, (DraftContext)ctx));
                }
                return null;
            });
        }
        return deserializedMap;
    }

    private T deserializeImpl(byte[] value, DraftContext ctx) {
        Object deserializedValue;
        if (value == null || value.length == 0 || Arrays.equals(value, NULL_BYTES)) {
            return null;
        }
        try {
            deserializedValue = this.mapper.readValue(value, this.valueType);
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        return (T)(ctx != null ? ctx.resolveObject(deserializedValue) : deserializedValue);
    }
}

