/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.loader.spi;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.babyfish.jimmer.lang.Ref;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.OrderedItem;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.TransientResolver;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractMutableQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.Queries;
import org.babyfish.jimmer.sql.ast.impl.query.SortableImplementor;
import org.babyfish.jimmer.sql.ast.query.MutableQuery;
import org.babyfish.jimmer.sql.ast.query.Sortable;
import org.babyfish.jimmer.sql.ast.table.Props;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheAbandonedCallback;
import org.babyfish.jimmer.sql.cache.CacheEnvironment;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.FieldFilter;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImpl;
import org.babyfish.jimmer.sql.fetcher.impl.FieldFilterArgsImpl;
import org.babyfish.jimmer.sql.filter.CacheableFilter;
import org.babyfish.jimmer.sql.filter.Filter;
import org.babyfish.jimmer.sql.filter.impl.FilterArgsImpl;
import org.babyfish.jimmer.sql.loader.spi.Utils;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.meta.Storage;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDataLoader.class);
    private static final SortedMap<String, Object> ILLEGAL_PARAMETERS = Collections.unmodifiableSortedMap(new TreeMap());
    private final JSqlClient sqlClient;
    private final Connection con;
    private final ImmutableProp prop;
    private final ImmutableProp sourceIdProp;
    private final ImmutableProp targetIdProp;
    private final Filter<Props> globalFiler;
    private final FieldFilter<Table<ImmutableSpi>> propFilter;
    private final int limit;
    private final int offset;
    private final TransientResolver<?, ?> resolver;
    private final Fetcher<ImmutableSpi> fetcher;

    protected AbstractDataLoader(JSqlClient sqlClient, Connection con, ImmutableType entityType, ImmutableProp prop, Fetcher<?> fetcher, FieldFilter<?> propFilter, int limit, int offset) {
        if (!prop.isAssociation(TargetLevel.ENTITY) && !prop.hasTransientResolver()) {
            throw new IllegalArgumentException("\"" + prop + "\" is neither association nor transient with resolver");
        }
        if (!prop.isAssociation(TargetLevel.ENTITY)) {
            if (fetcher != null) {
                throw new IllegalArgumentException("Cannot specify fetcher for scalar prop \"" + prop + "\"");
            }
            if (propFilter != null) {
                throw new IllegalArgumentException("Cannot specify filter for scalar prop \"" + prop + "\"");
            }
            if (limit != Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Cannot specify limit for scalar prop \"" + prop + "\"");
            }
            if (offset != 0) {
                throw new IllegalArgumentException("Cannot specify limit for scalar prop \"" + prop + "\"");
            }
        }
        if (entityType != null) {
            if (!entityType.isEntity()) {
                throw new IllegalArgumentException("\"" + entityType + "\" is not entity");
            }
        } else if (!prop.getDeclaringType().isEntity()) {
            throw new IllegalArgumentException("\"" + prop + "\" is not declared in entity");
        }
        this.sqlClient = sqlClient;
        this.con = con;
        this.prop = prop;
        this.sourceIdProp = prop.getDeclaringType().getIdProp();
        this.targetIdProp = prop.getTargetType() != null ? prop.getTargetType().getIdProp() : null;
        this.globalFiler = prop.isAssociation(TargetLevel.ENTITY) ? sqlClient.getFilters().getTargetFilter(prop) : null;
        this.propFilter = propFilter;
        if (prop.isReference(TargetLevel.ENTITY) && !prop.isNullable()) {
            if (this.globalFiler != null) {
                throw new ExecutionException("Cannot apply filter \"" + this.globalFiler + "\" for \"" + prop + "\" because that property is not nullable");
            }
            if (propFilter != null) {
                throw new ExecutionException("Cannot apply field filter of object fetcher for \"" + prop + "\" because that property is not nullable");
            }
        }
        this.limit = limit;
        this.offset = offset;
        if (prop.isAssociation(TargetLevel.ENTITY)) {
            this.resolver = null;
            this.fetcher = fetcher != null ? fetcher : new FetcherImpl(prop.getTargetType().getJavaClass());
        } else {
            this.resolver = sqlClient.getResolver(prop);
            this.fetcher = null;
        }
    }

    public Map<ImmutableSpi, Object> load(Collection<ImmutableSpi> sources) {
        if (sources.isEmpty()) {
            return Collections.emptyMap();
        }
        if (sources.size() > 1 && (this.limit != Integer.MAX_VALUE || this.offset != 0)) {
            throw new IllegalArgumentException("Pagination data loader does not support batch loading");
        }
        if (this.resolver != null) {
            return this.loadTransients(sources);
        }
        if (this.prop.getStorage() instanceof ColumnDefinition) {
            return this.loadParents(sources);
        }
        if (this.prop.isReferenceList(TargetLevel.ENTITY)) {
            return this.loadTargetMultiMap(sources);
        }
        return this.loadTargetMap(sources);
    }

    private Map<ImmutableSpi, Object> loadTransients(Collection<ImmutableSpi> sources) {
        boolean useCache;
        Cache.Parameterized parameterizedCache;
        List<Object> sourceIds = this.toSourceIds(sources);
        TransientResolver<?, ?> resolver = this.resolver;
        Cache cache = this.sqlClient.getCaches().getPropertyCache(this.prop);
        Ref<SortedMap<String, Object>> parameterMapRef = resolver.getParameterMapRef();
        SortedMap parameterMap = parameterMapRef != null ? (SortedMap)parameterMapRef.getValue() : null;
        Cache.Parameterized parameterized = parameterizedCache = cache instanceof Cache.Parameterized ? (Cache.Parameterized)cache : null;
        if (cache != null) {
            CacheAbandonedCallback callback;
            if (parameterMapRef == null) {
                useCache = false;
                callback = this.sqlClient.getCaches().getAbandonedCallback();
                if (callback != null) {
                    callback.abandoned(this.prop, CacheAbandonedCallback.Reason.CACHEABLE_FILTER_REQUIRED);
                }
            } else if (parameterMap != null && !parameterMap.isEmpty() && parameterizedCache == null) {
                useCache = false;
                callback = this.sqlClient.getCaches().getAbandonedCallback();
                if (callback != null) {
                    callback.abandoned(this.prop, CacheAbandonedCallback.Reason.PARAMETERIZED_CACHE_REQUIRED);
                }
            } else {
                useCache = true;
            }
        } else {
            useCache = false;
        }
        if (!useCache) {
            return Utils.joinCollectionAndMap(sources, this::toSourceId, resolver.resolve(sourceIds, this.con));
        }
        CacheEnvironment env = new CacheEnvironment(this.sqlClient, this.con, ids -> resolver.resolve(ids, this.con), false);
        Map valueMap = parameterMap != null && !parameterMap.isEmpty() && parameterizedCache != null ? parameterizedCache.getAll(sourceIds, (SortedMap)parameterMapRef.getValue(), env) : cache.getAll(sourceIds, env);
        return Utils.joinCollectionAndMap(sources, this::toSourceId, valueMap);
    }

    private Map<ImmutableSpi, ImmutableSpi> loadParents(Collection<ImmutableSpi> sources) {
        SortedMap<String, Object> parameters;
        Cache fkCache = this.sqlClient.getCaches().getPropertyCache(this.prop);
        if (!this.useCache(fkCache, parameters = this.getParameters())) {
            return this.loadParentsDirectly(sources);
        }
        LinkedHashMap<Object, Object> fkMap = new LinkedHashMap<Object, Object>((sources.size() * 4 + 2) / 3);
        List<Object> missedFkSourceIds = new ArrayList();
        if (this.globalFiler != null) {
            missedFkSourceIds = this.toSourceIds(sources);
        } else {
            for (ImmutableSpi source : sources) {
                if (source.__isLoaded(this.prop.getId())) {
                    ImmutableSpi target = (ImmutableSpi)source.__get(this.prop.getId());
                    if (target == null) continue;
                    fkMap.put(this.toSourceId(source), this.toTargetId(target));
                    continue;
                }
                missedFkSourceIds.add(this.toSourceId(source));
            }
        }
        if (!missedFkSourceIds.isEmpty()) {
            CacheEnvironment env = new CacheEnvironment(this.sqlClient, this.con, this::queryForeignKeyMap, false);
            Map cachedFkMap = parameters != null ? ((Cache.Parameterized)fkCache).getAll(missedFkSourceIds, parameters, env) : fkCache.getAll(missedFkSourceIds, env);
            for (Object e : missedFkSourceIds) {
                Object fk = cachedFkMap.get(e);
                if (fk == null) continue;
                fkMap.put(e, fk);
            }
        }
        Map targetMap = Utils.joinMaps(fkMap, Utils.toMap(this::toTargetId, this.findTargets(new LinkedHashSet<Object>(fkMap.values()))));
        return Utils.joinCollectionAndMap(sources, this::toSourceId, targetMap);
    }

    private Map<ImmutableSpi, ImmutableSpi> loadParentsDirectly(Collection<ImmutableSpi> sources) {
        LinkedHashMap<Object, Object> fkMap = new LinkedHashMap<Object, Object>((sources.size() * 4 + 2) / 3);
        ArrayList<Object> missedFkSourceIds = new ArrayList<Object>();
        for (ImmutableSpi source : sources) {
            if (source.__isLoaded(this.prop.getId())) {
                ImmutableSpi target = (ImmutableSpi)source.__get(this.prop.getId());
                if (target == null) continue;
                fkMap.put(this.toSourceId(source), this.toTargetId(target));
                continue;
            }
            missedFkSourceIds.add(this.toSourceId(source));
        }
        Map map1 = null;
        if (!fkMap.isEmpty()) {
            map1 = this.globalFiler != null || this.propFilter != null ? Utils.joinMaps(fkMap, Utils.toMap(this::toTargetId, this.queryTargets(fkMap.values()))) : Utils.joinMaps(fkMap, Utils.toMap(this::toTargetId, this.findTargets(fkMap.values())));
        }
        Map map2 = null;
        if (!missedFkSourceIds.isEmpty()) {
            if (this.globalFiler != null || this.propFilter != null || this.fetcher.getFieldMap().size() > 1) {
                map2 = Tuple2.toMap(this.querySourceTargetPairs(missedFkSourceIds));
            } else {
                Map<Object, Object> loadedFkMap = this.queryForeignKeyMap(missedFkSourceIds);
                map2 = new LinkedHashMap((missedFkSourceIds.size() * 4 + 2) / 3);
                for (Object e : missedFkSourceIds) {
                    Object targetId = loadedFkMap.get(e);
                    map2.put(e, this.makeIdOnlyTarget(targetId));
                }
            }
        }
        return Utils.joinCollectionAndMap(sources, this::toSourceId, Utils.mergeMap(map1, map2));
    }

    private Map<ImmutableSpi, ImmutableSpi> loadTargetMap(Collection<ImmutableSpi> sources) {
        SortedMap<String, Object> parameters;
        Cache cache = this.sqlClient.getCaches().getPropertyCache(this.prop);
        if (!this.useCache(cache, parameters = this.getParameters())) {
            return this.loadTargetMapDirectly(sources);
        }
        List<Object> sourceIds = this.toSourceIds(sources);
        CacheEnvironment env = new CacheEnvironment(this.sqlClient, this.con, it -> Tuple2.toMap(this.querySourceTargetIdPairs(it)), false);
        Map idMap = parameters != null ? ((Cache.Parameterized)cache).getAll(sourceIds, parameters, env) : cache.getAll(sourceIds, env);
        Map<Function<ImmutableSpi, Object>, ImmutableSpi> targetMap = Utils.toMap(this::toTargetId, this.findTargets(new LinkedHashSet<Object>(idMap.values())));
        return Utils.joinCollectionAndMap(sources, this::toSourceId, Utils.joinMaps(idMap, targetMap));
    }

    private Map<ImmutableSpi, ImmutableSpi> loadTargetMapDirectly(Collection<ImmutableSpi> sources) {
        List<Object> sourceIds = this.toSourceIds(sources);
        Map targetMap = this.globalFiler != null || this.propFilter != null || this.fetcher.getFieldMap().size() > 1 ? Tuple2.toMap(this.querySourceTargetPairs(sourceIds)) : Tuple2.toMap(this.querySourceTargetIdPairs(sourceIds), this::makeIdOnlyTarget);
        return Utils.joinCollectionAndMap(sources, this::toSourceId, targetMap);
    }

    private Map<ImmutableSpi, List<ImmutableSpi>> loadTargetMultiMap(Collection<ImmutableSpi> sources) {
        SortedMap<String, Object> parameters;
        Cache cache = this.sqlClient.getCaches().getPropertyCache(this.prop);
        if (!this.useCache(cache, parameters = this.getParameters())) {
            return this.loadTargetMultiMapDirectly(sources);
        }
        List<Object> sourceIds = this.toSourceIds(sources);
        CacheEnvironment env = new CacheEnvironment(this.sqlClient, this.con, it -> Tuple2.toMultiMap(this.querySourceTargetIdPairs(it)), false);
        Map idMultiMap = parameters != null ? ((Cache.Parameterized)cache).getAll(sourceIds, parameters, env) : cache.getAll(sourceIds, env);
        Map<Function<ImmutableSpi, Object>, ImmutableSpi> targetMap = Utils.toMap(this::toTargetId, this.findTargets(idMultiMap.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).distinct().collect(Collectors.toList())));
        return Utils.joinCollectionAndMap(sources, this::toSourceId, Utils.joinMultiMapAndMap(idMultiMap, targetMap));
    }

    private Map<ImmutableSpi, List<ImmutableSpi>> loadTargetMultiMapDirectly(Collection<ImmutableSpi> sources) {
        List<Object> sourceIds = this.toSourceIds(sources);
        Map targetMap = this.globalFiler != null || this.propFilter != null || this.fetcher.getFieldMap().size() > 1 ? Tuple2.toMultiMap(this.querySourceTargetPairs(sourceIds)) : Tuple2.toMultiMap(this.querySourceTargetIdPairs(sourceIds), this::makeIdOnlyTarget);
        return Utils.joinCollectionAndMap(sources, this::toSourceId, targetMap);
    }

    private Map<Object, Object> queryForeignKeyMap(Collection<Object> sourceIds) {
        if (sourceIds.size() == 1) {
            Object sourceId = sourceIds.iterator().next();
            List targetIds = (List)Queries.createQuery(this.sqlClient, this.prop.getDeclaringType(), ExecutionPurpose.LOADER, true, (q, source) -> {
                Object pkExpr = source.get(this.sourceIdProp.getName());
                Object targetTable = source.join(this.prop.getName());
                Object fkExpr = targetTable.get(this.targetIdProp.getName());
                q.where(new Predicate[]{pkExpr.eq((Object)sourceId)});
                q.where(new Predicate[]{fkExpr.isNotNull()});
                if (!this.applyPropFilter((MutableQuery)q, (Table<?>)targetTable, sourceIds) & !this.applyGlobalFilter((Sortable)q, (Table<?>)targetTable)) {
                    this.applyDefaultOrder((MutableQuery)q, (Table<?>)targetTable);
                }
                return q.select(fkExpr);
            }).limit(this.limit, this.offset).execute(this.con);
            return Utils.toMap(sourceId, targetIds);
        }
        List tuples = (List)Queries.createQuery(this.sqlClient, this.prop.getDeclaringType(), ExecutionPurpose.LOADER, true, (q, source) -> {
            Object pkExpr = source.get(this.sourceIdProp.getName());
            Object targetTable = source.join(this.prop.getName());
            Object fkExpr = targetTable.get(this.targetIdProp.getName());
            q.where(new Predicate[]{pkExpr.in(sourceIds)});
            q.where(new Predicate[]{fkExpr.isNotNull()});
            if (!this.applyPropFilter((MutableQuery)q, (Table<?>)targetTable, sourceIds) & !this.applyGlobalFilter((Sortable)q, (Table<?>)targetTable)) {
                this.applyDefaultOrder((MutableQuery)q, (Table<?>)targetTable);
            }
            return q.select(pkExpr, fkExpr);
        }).execute(this.con);
        return Tuple2.toMap(tuples);
    }

    private List<Tuple2<Object, Object>> querySourceTargetIdPairs(Collection<Object> sourceIds) {
        if (this.propFilter == null) {
            boolean useMiddleTable = false;
            Storage storage = this.prop.getStorage();
            if (storage != null) {
                useMiddleTable = storage instanceof MiddleTable;
            } else {
                ImmutableProp mappedBy = this.prop.getMappedBy();
                if (mappedBy != null && mappedBy.getStorage() instanceof MiddleTable) {
                    useMiddleTable = true;
                }
            }
            if (useMiddleTable) {
                if (sourceIds.size() == 1) {
                    Object sourceId = sourceIds.iterator().next();
                    List targetIds = (List)Queries.createAssociationQuery(this.sqlClient, AssociationType.of(this.prop), ExecutionPurpose.LOADER, (q, association) -> {
                        Object sourceIdExpr = association.source(this.prop.getDeclaringType()).get(this.sourceIdProp.getName());
                        Object targetIdExpr = association.target().get(this.targetIdProp.getName());
                        q.where(new Predicate[]{sourceIdExpr.eq((Object)sourceId)});
                        this.applyPropFilter((MutableQuery)q, (Table<?>)association.target(), sourceIds);
                        this.applyGlobalFilter((Sortable)q, (Table<?>)association.target());
                        return q.select(targetIdExpr);
                    }).limit(this.limit, this.offset).execute(this.con);
                    return Utils.toTuples(sourceId, targetIds);
                }
                return (List)Queries.createAssociationQuery(this.sqlClient, AssociationType.of(this.prop), ExecutionPurpose.LOADER, (q, association) -> {
                    Object sourceIdExpr = association.source(this.prop.getDeclaringType()).get(this.sourceIdProp.getName());
                    Object targetIdExpr = association.target().get(this.targetIdProp.getName());
                    q.where(new Predicate[]{sourceIdExpr.in(sourceIds)});
                    this.applyPropFilter((MutableQuery)q, (Table<?>)association.target(), sourceIds);
                    this.applyGlobalFilter((Sortable)q, (Table<?>)association.target());
                    return q.select(sourceIdExpr, targetIdExpr);
                }).execute(this.con);
            }
        }
        return this.executeTupleQuery(sourceIds, target -> target.get(this.targetIdProp.getName()));
    }

    private List<Tuple2<Object, ImmutableSpi>> querySourceTargetPairs(Collection<Object> sourceIds) {
        return this.executeTupleQuery(sourceIds, target -> target.fetch(this.fetcher));
    }

    private List<ImmutableSpi> queryTargets(Collection<Object> targetIds) {
        return (List)Queries.createQuery(this.sqlClient, this.prop.getTargetType(), ExecutionPurpose.LOADER, true, (q, target) -> {
            Object idExpr = target.get(this.targetIdProp.getName());
            q.where(new Predicate[]{idExpr.in(targetIds)});
            if (!this.applyPropFilter((MutableQuery)q, (Table<?>)target, targetIds) & !this.applyGlobalFilter((Sortable)q, (Table<?>)target)) {
                this.applyDefaultOrder((MutableQuery)q, (Table<?>)target);
            }
            return q.select(target.fetch(this.fetcher));
        }).execute(this.con);
    }

    private <R> List<Tuple2<Object, R>> executeTupleQuery(Collection<Object> sourceIds, Function<Table<ImmutableSpi>, Selection<?>> valueExpressionGetter) {
        if (sourceIds.size() == 1) {
            Object sourceId = sourceIds.iterator().next();
            List results = (List)Queries.createQuery(this.sqlClient, this.prop.getTargetType(), ExecutionPurpose.LOADER, true, (q, target) -> {
                Object sourceIdExpr = target.inverseJoin(this.prop).get(this.sourceIdProp.getName());
                q.where(new Predicate[]{sourceIdExpr.eq((Object)sourceId)});
                if (!this.applyPropFilter((MutableQuery)q, (Table<?>)target, sourceIds) & !this.applyGlobalFilter((Sortable)q, (Table<?>)target)) {
                    this.applyDefaultOrder((MutableQuery)q, (Table<?>)target);
                }
                return q.select((Selection)valueExpressionGetter.apply((Table<ImmutableSpi>)target));
            }).limit(this.limit, this.offset).execute(this.con);
            return Utils.toTuples(sourceId, results);
        }
        return (List)Queries.createQuery(this.sqlClient, this.prop.getTargetType(), ExecutionPurpose.LOADER, true, (q, target) -> {
            Object sourceIdExpr = target.inverseJoin(this.prop).get(this.sourceIdProp.getName());
            q.where(new Predicate[]{sourceIdExpr.in(sourceIds)});
            if (!this.applyPropFilter((MutableQuery)q, (Table<?>)target, sourceIds) & !this.applyGlobalFilter((Sortable)q, (Table<?>)target)) {
                this.applyDefaultOrder((MutableQuery)q, (Table<?>)target);
            }
            return q.select(sourceIdExpr, (Selection)valueExpressionGetter.apply((Table<ImmutableSpi>)target));
        }).execute(this.con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean applyGlobalFilter(Sortable sortable, Table<?> table) {
        SortableImplementor sortableImplementor = (SortableImplementor)sortable;
        Filter<Props> globalFiler = this.globalFiler;
        if (globalFiler instanceof CacheableFilter) {
            sortableImplementor.disableSubQuery();
            try {
                FilterArgsImpl args = new FilterArgsImpl(sortableImplementor, table, true);
                globalFiler.filter(args);
                boolean bl = args.isSorted();
                return bl;
            }
            finally {
                sortableImplementor.enableSubQuery();
            }
        }
        if (globalFiler != null) {
            FilterArgsImpl args = new FilterArgsImpl(sortableImplementor, table, false);
            globalFiler.filter(args);
            return args.isSorted();
        }
        return false;
    }

    private boolean applyPropFilter(MutableQuery query, Table<?> table, Collection<Object> keys) {
        if (this.propFilter != null) {
            FieldFilterArgsImpl<Table<?>> args = FieldFilterArgsImpl.of((AbstractMutableQueryImpl)query, table, keys);
            this.propFilter.apply(args);
            return args.isSorted();
        }
        return false;
    }

    private void applyDefaultOrder(MutableQuery query, Table<?> table) {
        List orderedItems = this.prop.getOrderedItems();
        if (!orderedItems.isEmpty()) {
            for (OrderedItem orderedItem : orderedItems) {
                Object expr = table.get(orderedItem.getProp().getName());
                if (orderedItem.isDesc()) {
                    query.orderBy(expr.desc());
                    continue;
                }
                query.orderBy(new Expression[]{expr});
            }
        }
    }

    private Object toSourceId(ImmutableSpi source) {
        return source.__get(this.sourceIdProp.getId());
    }

    private List<Object> toSourceIds(Collection<ImmutableSpi> sources) {
        return sources.stream().map(this::toSourceId).collect(Collectors.toList());
    }

    private Object toTargetId(ImmutableSpi target) {
        if (target == null) {
            return null;
        }
        return target.__get(this.targetIdProp.getId());
    }

    private List<ImmutableSpi> findTargets(Collection<Object> targetIds) {
        if (this.fetcher.getFieldMap().size() > 1) {
            return this.sqlClient.getEntities().forConnection(this.con).findByIds(this.fetcher, targetIds);
        }
        return this.makeIdOnlyTargets(targetIds);
    }

    private List<ImmutableSpi> makeIdOnlyTargets(Collection<Object> targetIds) {
        return targetIds.stream().map(this::makeIdOnlyTarget).collect(Collectors.toCollection(() -> new ArrayList(targetIds.size())));
    }

    private ImmutableSpi makeIdOnlyTarget(Object id) {
        if (id == null) {
            return null;
        }
        return (ImmutableSpi)Internal.produce((ImmutableType)this.prop.getTargetType(), null, draft -> {
            DraftSpi targetDraft = (DraftSpi)draft;
            targetDraft.__set(this.targetIdProp.getId(), id);
        });
    }

    private SortedMap<String, Object> getParameters() {
        Filter<Props> filter = this.globalFiler;
        if (filter instanceof CacheableFilter) {
            SortedMap<String, Object> parameters = ((CacheableFilter)filter).getParameters();
            if (parameters != null && parameters.isEmpty()) {
                return null;
            }
            return parameters;
        }
        if (filter != null) {
            return ILLEGAL_PARAMETERS;
        }
        return null;
    }

    private boolean useCache(Cache<?, ?> cache, Map<String, Object> parameters) {
        if (cache == null) {
            return false;
        }
        if (this.propFilter != null) {
            CacheAbandonedCallback callback = this.sqlClient.getCaches().getAbandonedCallback();
            if (callback != null) {
                callback.abandoned(this.prop, CacheAbandonedCallback.Reason.FIELD_FILTER_USED);
            }
            return false;
        }
        if (parameters == ILLEGAL_PARAMETERS) {
            CacheAbandonedCallback callback = this.sqlClient.getCaches().getAbandonedCallback();
            if (callback != null) {
                callback.abandoned(this.prop, CacheAbandonedCallback.Reason.CACHEABLE_FILTER_REQUIRED);
            }
            return false;
        }
        if (parameters != null && !(cache instanceof Cache.Parameterized)) {
            CacheAbandonedCallback callback = this.sqlClient.getCaches().getAbandonedCallback();
            if (callback != null) {
                callback.abandoned(this.prop, CacheAbandonedCallback.Reason.PARAMETERIZED_CACHE_REQUIRED);
            }
            return false;
        }
        return true;
    }
}

