/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.fetcher.impl.Fetchers;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Reader;
import org.babyfish.jimmer.sql.runtime.Readers;

public class Selectors {
    private Selectors() {
    }

    public static <R> List<R> select(JSqlClient sqlClient, Connection con, String sql, List<Object> variables, List<Selection<?>> selections, ExecutionPurpose purpose) {
        return sqlClient.getExecutor().execute(con, sql, variables, purpose, null, stmt -> {
            Reader<?> reader = Readers.createReader(sqlClient, selections);
            Reader.Col col = new Reader.Col();
            ArrayList results = new ArrayList();
            try (ResultSet resultSet = stmt.executeQuery();){
                while (resultSet.next()) {
                    results.add(reader.read(resultSet, col));
                    col.reset();
                }
            }
            Fetchers.fetch(sqlClient, con, selections, results);
            return results;
        });
    }

    public static <R> void forEach(JSqlClient sqlClient, Connection con, String sql, List<Object> variables, List<Selection<?>> selections, ExecutionPurpose purpose, int batchSize, Consumer<R> consumer) {
        sqlClient.getExecutor().execute(con, sql, variables, purpose, null, stmt -> {
            Reader<?> reader = Readers.createReader(sqlClient, selections);
            Reader.Col col = new Reader.Col();
            ArrayList results = new ArrayList();
            try (ResultSet resultSet = stmt.executeQuery();){
                while (resultSet.next()) {
                    results.add(reader.read(resultSet, col));
                    col.reset();
                    if (results.size() < batchSize) continue;
                    Fetchers.fetch(sqlClient, con, selections, results);
                    for (Object result : results) {
                        consumer.accept(result);
                    }
                    results.clear();
                }
            }
            Fetchers.fetch(sqlClient, con, selections, results);
            for (Object result : results) {
                consumer.accept(result);
            }
            return null;
        });
    }
}

