/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.impl.DatabaseIdentifiers;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityManager {
    private final Map<ImmutableType, ImmutableTypeInfo> map;
    private final Map<String, ImmutableType> tableNameTypeMap;

    public EntityManager(Class<?> ... classes) {
        this(Arrays.asList(classes));
    }

    public EntityManager(Collection<Class<?>> classes) {
        if (classes.isEmpty()) {
            throw new IllegalArgumentException("classes cannot be empty");
        }
        if (!(classes instanceof Set)) {
            classes = new LinkedHashSet(classes);
        }
        LinkedHashMap<ImmutableType, ImmutableTypeInfo> map = new LinkedHashMap<ImmutableType, ImmutableTypeInfo>();
        for (Class<?> clazz : classes) {
            if (clazz == null) continue;
            ImmutableType immutableType = ImmutableType.get(clazz);
            if (!immutableType.isEntity()) {
                throw new IllegalArgumentException("\"" + immutableType + "\" is not entity");
            }
            map.put(immutableType, new ImmutableTypeInfo());
            for (immutableType = immutableType.getSuperType(); immutableType != null && (immutableType.isEntity() || immutableType.isMappedSuperclass()); immutableType = immutableType.getSuperType()) {
                map.put(immutableType, new ImmutableTypeInfo());
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            ImmutableType type = (ImmutableType)entry.getKey();
            ImmutableTypeInfo info = (ImmutableTypeInfo)entry.getValue();
            if (type.isMappedSuperclass()) {
                for (ImmutableType otherType : map.keySet()) {
                    if (!this.isImplementationType(type, otherType)) continue;
                    info.implementationTypes.add(otherType);
                }
                continue;
            }
            for (ImmutableType otherType : map.keySet()) {
                if (type == otherType || !type.isAssignableFrom(otherType)) continue;
                info.allDerivedTypes.add(otherType);
                if (type != otherType.getSuperType()) continue;
                info.directDerivedTypes.add(otherType);
            }
            for (ImmutableProp prop : EntityManager.entityProps(type)) {
                ImmutableType targetType = prop.getTargetType();
                if (targetType == null || !targetType.isEntity()) continue;
                ImmutableTypeInfo targetInfo = (ImmutableTypeInfo)map.get(targetType);
                if (targetInfo == null) {
                    throw new IllegalArgumentException("The target type \"" + targetType + "\" of the property \"" + prop + "\" is not manged by the current entity manager");
                }
                targetInfo.backProps.add(prop);
            }
        }
        for (ImmutableTypeInfo immutableTypeInfo : map.values()) {
            immutableTypeInfo.implementationTypes = Collections.unmodifiableList(immutableTypeInfo.implementationTypes);
            immutableTypeInfo.directDerivedTypes = Collections.unmodifiableList(immutableTypeInfo.directDerivedTypes);
            immutableTypeInfo.allDerivedTypes = Collections.unmodifiableList(immutableTypeInfo.allDerivedTypes);
            immutableTypeInfo.backProps = Collections.unmodifiableList(immutableTypeInfo.backProps);
        }
        this.map = map;
        this.tableNameTypeMap = this.createTableNameTypeMap();
    }

    public static EntityManager combine(EntityManager ... entityManagers) {
        if (entityManagers.length == 0) {
            throw new IllegalArgumentException("No entity managers");
        }
        if (entityManagers.length == 1) {
            return entityManagers[0];
        }
        LinkedHashSet classes = new LinkedHashSet();
        for (EntityManager entityManager : entityManagers) {
            for (ImmutableType type : entityManager.getAllTypes()) {
                classes.add(type.getJavaClass());
            }
        }
        return new EntityManager(classes);
    }

    public Set<ImmutableType> getAllTypes() {
        return this.map.keySet();
    }

    public List<ImmutableType> getImplementationTypes(ImmutableType type) {
        return this.info((ImmutableType)type).implementationTypes;
    }

    public List<ImmutableType> getDirectDerivedTypes(ImmutableType type) {
        return this.info((ImmutableType)type).directDerivedTypes;
    }

    public List<ImmutableType> getAllDerivedTypes(ImmutableType type) {
        return this.info((ImmutableType)type).allDerivedTypes;
    }

    public List<ImmutableProp> getAllBackProps(ImmutableType type) {
        return this.info((ImmutableType)type).backProps;
    }

    @Nullable
    public ImmutableType getTypeByTableName(String tableName) {
        String standardTableName = DatabaseIdentifiers.comparableIdentifier((String)tableName);
        return this.tableNameTypeMap.get(standardTableName);
    }

    @NotNull
    public ImmutableType getNonNullTypeByTableName(String tableName) {
        ImmutableType type = this.getTypeByTableName(tableName);
        if (type == null) {
            throw new IllegalArgumentException("The table \"" + tableName + "\" is not managed by current EntityManager");
        }
        return type;
    }

    private ImmutableTypeInfo info(ImmutableType type) {
        ImmutableTypeInfo info = this.map.get(type);
        if (info == null) {
            throw new IllegalArgumentException("\"" + type + "\" is not managed by current EntityManager");
        }
        return info;
    }

    private boolean isImplementationType(ImmutableType mappedSuperClass, ImmutableType type) {
        if (!mappedSuperClass.isMappedSuperclass()) {
            throw new AssertionError((Object)"Internal bug");
        }
        if (!type.isEntity()) {
            return false;
        }
        if (!mappedSuperClass.isAssignableFrom(type)) {
            return false;
        }
        return type.getSuperType().isMappedSuperclass();
    }

    private Map<String, ImmutableType> createTableNameTypeMap() {
        HashMap<String, ImmutableType> tableNameTypeMap = new HashMap<String, ImmutableType>();
        for (ImmutableType type : this.map.keySet()) {
            if (!type.isEntity()) continue;
            String tableName = DatabaseIdentifiers.comparableIdentifier((String)type.getTableName());
            ImmutableType oldType = tableNameTypeMap.put(tableName, type);
            if (oldType != null) {
                throw new IllegalArgumentException("Illegal entity manager, the table \"" + tableName + "\" is shared by both \"" + oldType + "\" and \"" + type + "\"");
            }
            tableNameTypeMap.put(tableName, type);
            for (ImmutableProp prop : EntityManager.entityProps(type)) {
                if (!(prop.getStorage() instanceof MiddleTable)) continue;
                AssociationType associationType = AssociationType.of(prop);
                String associationTableName = DatabaseIdentifiers.comparableIdentifier((String)associationType.getTableName());
                ImmutableType oldAssociationType = tableNameTypeMap.put(associationTableName, associationType);
                if (oldAssociationType != null && !oldAssociationType.equals((Object)associationType)) {
                    throw new IllegalArgumentException("Illegal mapping, the table \"" + associationTableName + "\" is shared by both \"" + oldAssociationType + "\" and \"" + associationType + "\"");
                }
                tableNameTypeMap.put(associationTableName, associationType);
            }
        }
        return tableNameTypeMap;
    }

    private static Collection<ImmutableProp> entityProps(ImmutableType type) {
        ImmutableType superType = type.getSuperType();
        if (superType != null && superType.isMappedSuperclass()) {
            return type.getProps().values();
        }
        return type.getDeclaredProps().values();
    }

    private static class ImmutableTypeInfo {
        List<ImmutableType> implementationTypes = new ArrayList<ImmutableType>();
        List<ImmutableType> directDerivedTypes = new ArrayList<ImmutableType>();
        List<ImmutableType> allDerivedTypes = new ArrayList<ImmutableType>();
        List<ImmutableProp> backProps = new ArrayList<ImmutableProp>();

        private ImmutableTypeInfo() {
        }
    }
}

