/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import java.sql.Connection;
import java.util.Objects;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.cache.CacheLoader;
import org.babyfish.jimmer.sql.cache.CacheLoaderWrapper;
import org.jetbrains.annotations.NotNull;

public class CacheEnvironment<K, V> {
    private final JSqlClient sqlClient;
    private final Connection connection;
    private final CacheLoader<K, V> loader;

    public CacheEnvironment(JSqlClient sqlClient, Connection connection, CacheLoader<K, V> loader, boolean requiresNewDraftContext) {
        this.sqlClient = Objects.requireNonNull(sqlClient, "sqlClient cannot be null");
        this.connection = Objects.requireNonNull(connection, "connection cannot be null");
        this.loader = CacheLoaderWrapper.wrap(Objects.requireNonNull(loader, "loader cannot be null"), requiresNewDraftContext);
    }

    @NotNull
    public JSqlClient getSqlClient() {
        return this.sqlClient;
    }

    @NotNull
    public Connection getConnection() {
        return this.connection;
    }

    @NotNull
    public CacheLoader<K, V> getLoader() {
        return this.loader;
    }

    public int hashCode() {
        return Objects.hash(this.sqlClient, this.connection, this.loader);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheEnvironment that = (CacheEnvironment)o;
        return this.sqlClient.equals(that.sqlClient) && this.connection.equals(that.connection) && Objects.equals(this.loader, that.loader);
    }

    public String toString() {
        return "CacheEnvironment{sqlClient=" + this.sqlClient + ", connection=" + this.connection + ", loader=" + this.loader + '}';
    }
}

