/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.babyfish.jimmer.impl.util.StaticCache;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.ImmutableSpi;

public class EmbeddableObjects {
    private static final StaticCache<ImmutableType, List<Class<?>>> FLAT_TYPES_CACHE = new StaticCache(EmbeddableObjects::createFlatTypes, false);

    private EmbeddableObjects() {
    }

    public static List<Class<?>> expandTypes(ImmutableType type) {
        return (List)FLAT_TYPES_CACHE.get((Object)type);
    }

    public static Object[] expand(ImmutableType type, Object obj) {
        if (obj != null && !type.getJavaClass().isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("Illegal obj, it does not match the type \"" + type + "\"");
        }
        Object[] values = new Object[((List)FLAT_TYPES_CACHE.get((Object)type)).size()];
        if (obj != null) {
            EmbeddableObjects.expandImpl((ImmutableSpi)obj, values, 0);
        }
        return values;
    }

    private static int expandImpl(ImmutableSpi spi, Object[] values, int index) {
        for (ImmutableProp prop : spi.__type().getProps().values()) {
            Object value = spi.__get(prop.getId());
            if (prop.isEmbedded(EmbeddedLevel.SCALAR)) {
                index = EmbeddableObjects.expandImpl((ImmutableSpi)value, values, index);
                continue;
            }
            values[index++] = value;
        }
        return index;
    }

    private static List<Class<?>> createFlatTypes(ImmutableType type) {
        if (!type.isEmbeddable()) {
            throw new IllegalArgumentException("Illegal obj, it does not match the type \"" + type + "\"");
        }
        ArrayList flatTypes = new ArrayList();
        EmbeddableObjects.collectFlatTypes(type, flatTypes);
        return Collections.unmodifiableList(flatTypes);
    }

    private static void collectFlatTypes(ImmutableType type, List<Class<?>> flatTypes) {
        for (ImmutableProp prop : type.getProps().values()) {
            if (prop.isEmbedded(EmbeddedLevel.SCALAR)) {
                EmbeddableObjects.collectFlatTypes(prop.getTargetType(), flatTypes);
                continue;
            }
            flatTypes.add(prop.getElementClass());
        }
    }

    public static boolean isCompleted(Object embedded) {
        if (!(embedded instanceof ImmutableSpi)) {
            throw new IllegalArgumentException("The argument must be embeddable type");
        }
        return EmbeddableObjects.isCompleted((ImmutableSpi)embedded);
    }

    private static boolean isCompleted(ImmutableSpi spi) {
        ImmutableType type = spi.__type();
        if (type.isEntity()) {
            return EmbeddableObjects.isCompleted(spi, type.getIdProp());
        }
        for (ImmutableProp prop : type.getProps().values()) {
            if (EmbeddableObjects.isCompleted(spi, prop)) continue;
            return false;
        }
        return true;
    }

    private static boolean isCompleted(ImmutableSpi spi, ImmutableProp prop) {
        ImmutableSpi childSpi;
        int propId = prop.getId();
        if (!spi.__isLoaded(propId)) {
            return false;
        }
        return !prop.isEmbedded(EmbeddedLevel.SCALAR) || (childSpi = (ImmutableSpi)spi.__get(propId)) == null || EmbeddableObjects.isCompleted(childSpi);
    }
}

