/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.table;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.impl.util.StaticCache;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.Entity;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.table.CustomWeakJoinTableExporter;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.WeakJoin;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.ast.table.spi.UntypedJoinDisabledTableProxy;

public class WeakJoinHandle {
    private static final String JOIN_ERROR_REASON = "it is forbidden in the implementation of \"" + WeakJoin.class.getName() + "\"";
    private static final StaticCache<Class<? extends WeakJoin<?, ?>>, WeakJoinHandle> CACHE = new StaticCache(WeakJoinHandle::create, false);
    private final ImmutableType sourceType;
    private final ImmutableType targetType;
    private final boolean hasSourceWrapper;
    private final boolean hasTargetWrapper;
    private final WeakJoin<Table<?>, Table<?>> weakJoin;

    private WeakJoinHandle(ImmutableType sourceType, ImmutableType targetType, boolean hasSourceWrapper, boolean hasTargetWrapper, WeakJoin<Table<?>, Table<?>> weakJoin) {
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.hasSourceWrapper = hasSourceWrapper;
        this.hasTargetWrapper = hasTargetWrapper;
        this.weakJoin = weakJoin;
    }

    public ImmutableType getSourceType() {
        return this.sourceType;
    }

    public ImmutableType getTargetType() {
        return this.targetType;
    }

    public Class<? extends WeakJoin<?, ?>> getWeakJoinType() {
        return this.weakJoin.getClass();
    }

    public String toString() {
        return "WeakJoinHandle{weakJoin=" + this.weakJoin + '}';
    }

    public Predicate createPredicate(TableImplementor<?> source, TableImplementor<?> target) {
        if (this.weakJoin instanceof CustomWeakJoinTableExporter) {
            return this.weakJoin.on(source instanceof TableProxy ? ((TableProxy)((Object)source)).__unwrap() : source, target instanceof TableProxy ? ((TableProxy)((Object)target)).__unwrap() : target);
        }
        return this.weakJoin.on((Table<?>)(this.hasSourceWrapper ? ((TableProxy)TableProxies.wrap(source)).__disableJoin(JOIN_ERROR_REASON) : new UntypedJoinDisabledTableProxy(source, JOIN_ERROR_REASON)), (Table<?>)(this.hasTargetWrapper ? ((TableProxy)TableProxies.wrap(target)).__disableJoin(JOIN_ERROR_REASON) : new UntypedJoinDisabledTableProxy(target, JOIN_ERROR_REASON)));
    }

    public static WeakJoinHandle of(Class<? extends WeakJoin<?, ?>> weakJoinType) {
        return (WeakJoinHandle)CACHE.get(weakJoinType);
    }

    private static WeakJoinHandle create(Class<? extends WeakJoin<?, ?>> weakJoinType) {
        WeakJoin<Table<?>, Table<?>> weakJoin;
        Constructor<WeakJoin<?, ?>> constructor;
        Map typeArguments = TypeUtils.getTypeArguments(weakJoinType, WeakJoin.class);
        if (typeArguments == null || typeArguments.isEmpty()) {
            throw new IllegalArgumentException("Illegal class \"" + weakJoinType.getName() + "\", generic arguments are missing");
        }
        Type sourceTableType = (Type)typeArguments.get(WeakJoin.class.getTypeParameters()[0]);
        Type targetTableType = (Type)typeArguments.get(WeakJoin.class.getTypeParameters()[1]);
        Type sourceType = (Type)TypeUtils.getTypeArguments((Type)sourceTableType, Table.class).values().iterator().next();
        Type targetType = (Type)TypeUtils.getTypeArguments((Type)targetTableType, Table.class).values().iterator().next();
        if (sourceType instanceof TypeVariable) {
            sourceType = (Type)typeArguments.get((TypeVariable)sourceType);
        }
        if (targetType instanceof TypeVariable) {
            targetType = (Type)typeArguments.get((TypeVariable)targetType);
        }
        if (!(sourceType instanceof Class) || !((Class)sourceType).isAnnotationPresent(Entity.class)) {
            throw new IllegalArgumentException("Illegal class \"" + weakJoinType.getName() + "\", the source type is not entity");
        }
        if (!(targetType instanceof Class) || !((Class)targetType).isAnnotationPresent(Entity.class)) {
            throw new IllegalArgumentException("Illegal class \"" + weakJoinType.getName() + "\", the target type is not entity");
        }
        boolean hasSourceWrapper = TableProxies.tableWrapperClass((Class)sourceType) != null;
        boolean hasTargetWrapper = TableProxies.tableWrapperClass((Class)targetType) != null;
        try {
            constructor = weakJoinType.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("No default constructor can be found in \"" + weakJoinType.getName() + "\"");
        }
        constructor.setAccessible(true);
        try {
            weakJoin = constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IllegalArgumentException("Cannot create instance of \"" + weakJoinType.getName() + "\"", ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException("Cannot create instance of \"" + weakJoinType.getName() + "\"", ex.getTargetException());
        }
        return new WeakJoinHandle(ImmutableType.get((Class)((Class)sourceType)), ImmutableType.get((Class)((Class)targetType)), hasSourceWrapper, hasTargetWrapper, weakJoin);
    }
}

