/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.sql.Connection;
import java.util.List;
import java.util.function.Consumer;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.query.TypedQueryImplementor;
import org.babyfish.jimmer.sql.ast.impl.query.TypedRootQueryImplementor;
import org.babyfish.jimmer.sql.ast.impl.query.UseTableVisitor;
import org.babyfish.jimmer.sql.ast.query.TypedRootQuery;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Selectors;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

class MergedTypedRootQueryImpl<R>
implements TypedRootQueryImplementor<R>,
TypedQueryImplementor {
    private JSqlClient sqlClient;
    private String operator;
    private TypedQueryImplementor left;
    private TypedQueryImplementor right;
    private List<Selection<?>> selections;
    private boolean isForUpdate;

    public MergedTypedRootQueryImpl(JSqlClient sqlClient, String operator, TypedRootQuery<R> left, TypedRootQuery<R> right) {
        this.sqlClient = sqlClient;
        this.operator = operator;
        this.left = (TypedQueryImplementor)((Object)left);
        this.right = (TypedQueryImplementor)((Object)right);
        this.selections = MergedTypedRootQueryImpl.mergedSelections(this.left.getSelections(), this.right.getSelections());
        this.isForUpdate = ((TypedRootQueryImplementor)left).isForUpdate() || ((TypedRootQueryImplementor)right).isForUpdate();
    }

    @Override
    public List<R> execute() {
        return this.sqlClient.getSlaveConnectionManager(this.isForUpdate).execute(this::executeImpl);
    }

    @Override
    public List<R> execute(Connection con) {
        if (con != null) {
            return this.executeImpl(con);
        }
        return this.sqlClient.getSlaveConnectionManager(this.isForUpdate).execute(this::executeImpl);
    }

    private List<R> executeImpl(Connection con) {
        Tuple2<String, List<Object>> sqlResult = this.preExecute(new SqlBuilder(new AstContext(this.sqlClient)));
        return Selectors.select(this.sqlClient, con, sqlResult.get_1(), sqlResult.get_2(), this.selections, ExecutionPurpose.QUERY);
    }

    @Override
    public void forEach(Connection con, int batchSize, Consumer<R> consumer) {
        int finalBatchSize;
        int n = finalBatchSize = batchSize > 0 ? batchSize : this.sqlClient.getDefaultBatchSize();
        if (con != null) {
            this.forEachImpl(con, finalBatchSize, consumer);
        } else {
            this.sqlClient.getSlaveConnectionManager(this.isForUpdate).execute((Connection newConn) -> {
                this.forEachImpl((Connection)newConn, finalBatchSize, consumer);
                return null;
            });
        }
    }

    private void forEachImpl(Connection con, int batchSize, Consumer<R> consumer) {
        Tuple2<String, List<Object>> sqlResult = this.preExecute(new SqlBuilder(new AstContext(this.sqlClient)));
        Selectors.forEach(this.sqlClient, con, sqlResult.get_1(), sqlResult.get_2(), this.selections, ExecutionPurpose.QUERY, batchSize, consumer);
    }

    private Tuple2<String, List<Object>> preExecute(SqlBuilder builder) {
        UseTableVisitor visitor = new UseTableVisitor(builder.getAstContext());
        this.accept(visitor);
        this.renderTo(builder);
        return builder.build();
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        this.left.accept(visitor);
        this.right.accept(visitor);
    }

    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        this.left.renderTo(builder);
        builder.sql(" ");
        builder.sql(this.operator);
        builder.sql(" ");
        this.right.renderTo(builder);
    }

    @Override
    public List<Selection<?>> getSelections() {
        return this.selections;
    }

    @Override
    public TypedRootQuery<R> union(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.sqlClient, "union", this, other);
    }

    @Override
    public TypedRootQuery<R> unionAll(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.sqlClient, "union all", this, other);
    }

    @Override
    public TypedRootQuery<R> minus(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.sqlClient, "minus", this, other);
    }

    @Override
    public TypedRootQuery<R> intersect(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.sqlClient, "intersect", this, other);
    }

    private static List<Selection<?>> mergedSelections(List<Selection<?>> list1, List<Selection<?>> list2) {
        if (list1.size() != list2.size()) {
            throw new IllegalArgumentException("Cannot merged sub queries with different selections");
        }
        int size = list1.size();
        for (int index = 0; index < size; ++index) {
            if (MergedTypedRootQueryImpl.isSameType(list1.get(index), list2.get(index))) continue;
            throw new IllegalArgumentException("Cannot merged sub queries with different selections");
        }
        return list1;
    }

    private static boolean isSameType(Selection<?> a, Selection<?> b) {
        if (a instanceof Table && b instanceof Table) {
            return ((Table)a).getImmutableType() == ((Table)b).getImmutableType();
        }
        if (a instanceof Expression && b instanceof Expression) {
            return ((ExpressionImplementor)a).getType() == ((ExpressionImplementor)b).getType();
        }
        return false;
    }

    @Override
    public boolean isForUpdate() {
        return false;
    }
}

