/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.math.BigDecimal;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AggregationExpression;
import org.babyfish.jimmer.sql.ast.impl.BetweenPredicate;
import org.babyfish.jimmer.sql.ast.impl.BinaryExpression;
import org.babyfish.jimmer.sql.ast.impl.CoalesceBuilder;
import org.babyfish.jimmer.sql.ast.impl.ComparableExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.ComparisonPredicate;
import org.babyfish.jimmer.sql.ast.impl.Literals;

interface NumericExpressionImplementor<N extends Number>
extends NumericExpression<N>,
ComparableExpressionImplementor<N> {
    @Override
    default public NumericExpression<N> plus(Expression<N> other) {
        return new BinaryExpression.Plus(this.getType(), this, other);
    }

    @Override
    default public NumericExpression<N> plus(N other) {
        return this.plus((N)Literals.number(other));
    }

    @Override
    default public NumericExpression<N> minus(Expression<N> other) {
        return new BinaryExpression.Minus(this.getType(), this, other);
    }

    @Override
    default public NumericExpression<N> minus(N other) {
        return this.minus((N)Literals.number(other));
    }

    @Override
    default public NumericExpression<N> times(Expression<N> other) {
        return new BinaryExpression.Times(this.getType(), this, other);
    }

    @Override
    default public NumericExpression<N> times(N other) {
        return this.times((N)Literals.number(other));
    }

    @Override
    default public NumericExpression<N> div(Expression<N> other) {
        return new BinaryExpression.Div(this.getType(), this, other);
    }

    @Override
    default public NumericExpression<N> div(N other) {
        return this.div((N)Literals.number(other));
    }

    @Override
    default public NumericExpression<N> rem(Expression<N> other) {
        return new BinaryExpression.Rem(this.getType(), this, other);
    }

    @Override
    default public NumericExpression<N> rem(N other) {
        return this.rem((N)Literals.number(other));
    }

    @Override
    default public Predicate lt(Expression<N> other) {
        return new ComparisonPredicate.Lt(this, other);
    }

    @Override
    default public Predicate lt(N other) {
        return this.lt((N)Literals.number(other));
    }

    @Override
    default public Predicate le(Expression<N> other) {
        return new ComparisonPredicate.Le(this, other);
    }

    @Override
    default public Predicate le(N other) {
        return this.le((N)Literals.number(other));
    }

    @Override
    default public Predicate gt(Expression<N> other) {
        return new ComparisonPredicate.Gt(this, other);
    }

    @Override
    default public Predicate gt(N other) {
        return this.gt((N)Literals.number(other));
    }

    @Override
    default public Predicate ge(Expression<N> other) {
        return new ComparisonPredicate.Ge(this, other);
    }

    @Override
    default public Predicate ge(N other) {
        return this.ge((N)Literals.number(other));
    }

    @Override
    default public Predicate between(Expression<N> min, Expression<N> max) {
        return new BetweenPredicate(false, this, min, max);
    }

    @Override
    default public Predicate between(N min, N max) {
        return new BetweenPredicate(false, this, Literals.any(min), Literals.any(max));
    }

    @Override
    default public Predicate notBetween(Expression<N> min, Expression<N> max) {
        return new BetweenPredicate(true, this, min, max);
    }

    @Override
    default public Predicate notBetween(N min, N max) {
        return new BetweenPredicate(true, this, Literals.any(min), Literals.any(max));
    }

    @Override
    default public NumericExpression<N> sum() {
        return new AggregationExpression.Sum(this);
    }

    @Override
    default public NumericExpression<N> min() {
        return new AggregationExpression.Min(this);
    }

    @Override
    default public NumericExpression<N> max() {
        return new AggregationExpression.Max(this);
    }

    @Override
    default public NumericExpression<BigDecimal> avg() {
        return new AggregationExpression.Avg(this);
    }

    @Override
    default public NumericExpression<N> coalesce(N defaultValue) {
        return ((CoalesceBuilder.Num)this.coalesceBuilder()).or(defaultValue).build();
    }

    @Override
    default public NumericExpression<N> coalesce(Expression<N> defaultExpr) {
        return ((CoalesceBuilder.Num)((CoalesceBuilder.Num)this.coalesceBuilder()).or((Expression)defaultExpr)).build();
    }

    @Override
    default public CoalesceBuilder.Num<N> coalesceBuilder() {
        return new CoalesceBuilder.Num(this);
    }
}

