/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.impl.util.Classes;
import org.babyfish.jimmer.impl.util.StaticCache;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.Transient;
import org.babyfish.jimmer.sql.TransientResolver;

class TransientResolverManager {
    private static final Class<?> K_SQL_CLIENT_CLASS;
    private static final Constructor<?> K_SQL_CLIENT_IMPL_CONSTRUCTOR;
    private final JSqlClient owner;
    private final StaticCache<ImmutableProp, TransientResolver<?, ?>> resolverCache = new StaticCache(this::createResolver, true);

    TransientResolverManager(JSqlClient owner) {
        this.owner = owner;
    }

    public TransientResolver<?, ?> get(ImmutableProp prop) {
        return (TransientResolver)this.resolverCache.get((Object)prop);
    }

    private TransientResolver<?, ?> createResolver(ImmutableProp prop) {
        if (!prop.getDeclaringType().isEntity()) {
            throw new IllegalArgumentException("\"" + prop + "\" is not declared in entity");
        }
        Transient trans = (Transient)prop.getAnnotation(Transient.class);
        if (trans == null) {
            return null;
        }
        Class resolverType = trans.value();
        if (resolverType == Void.TYPE) {
            return null;
        }
        if (!TransientResolver.class.isAssignableFrom(trans.value())) {
            throw new ModelException("Illegal property \"" + prop.getName() + "\", the resolver type must implement \"" + TransientResolver.class + "\"");
        }
        if (resolverType.isInterface() || (resolverType.getModifiers() & 0x400) != 0) {
            throw new ModelException("Illegal property \"" + prop.getName() + "\", the resolver type must be non-abstract class");
        }
        if (resolverType.getTypeParameters().length != 0) {
            throw new ModelException("Illegal property \"" + prop.getName() + "\", the resolver type cannot has parameters");
        }
        Map typeMap = TypeUtils.getTypeArguments((Type)resolverType, TransientResolver.class);
        Type keyType = (Type)typeMap.get(TransientResolver.class.getTypeParameters()[0]);
        Type valueType = (Type)typeMap.get(TransientResolver.class.getTypeParameters()[1]);
        if (!(keyType instanceof Class) || !Classes.matches((Class)((Class)keyType), (Class)prop.getDeclaringType().getIdProp().getElementClass())) {
            throw new ModelException("Illegal property \"" + prop.getName() + "\", the first generic type argument of resolver type must be \"" + prop.getDeclaringType().getIdProp().getElementClass() + "\"");
        }
        if (!(valueType instanceof Class) || !Classes.matches((Class)((Class)valueType), (Class)prop.getElementClass())) {
            throw new ModelException("Illegal property \"" + prop.getName() + "\", the second generic type argument of resolver type must be \"" + prop.getElementClass() + "\"");
        }
        Constructor constructor = null;
        try {
            constructor = resolverType.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (constructor != null) {
            try {
                return (TransientResolver)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw TransientResolverManager.convertResolverConstructorError(prop, ex);
            }
        }
        try {
            constructor = resolverType.getConstructor(JSqlClient.class);
        }
        catch (NoSuchMethodException ex) {
            // empty catch block
        }
        if (constructor != null) {
            try {
                return (TransientResolver)constructor.newInstance(this.owner);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw TransientResolverManager.convertResolverConstructorError(prop, ex);
            }
        }
        if (K_SQL_CLIENT_CLASS != null) {
            try {
                constructor = resolverType.getConstructor(K_SQL_CLIENT_CLASS);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            if (constructor != null) {
                Object kSqlClient;
                try {
                    kSqlClient = K_SQL_CLIENT_IMPL_CONSTRUCTOR.newInstance(this.owner);
                }
                catch (InvocationTargetException ex) {
                    throw new AssertionError("Internal bug", ex.getTargetException());
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    throw new AssertionError("Internal bug", ex);
                }
                try {
                    return (TransientResolver)constructor.newInstance(kSqlClient);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                    throw TransientResolverManager.convertResolverConstructorError(prop, ex);
                }
            }
        }
        throw new ModelException("The resolve type \"" + resolverType.getName() + "\" for the association \"" + prop + "\" does not have no-argument constructor or constructor that accepts SqlClient");
    }

    private static RuntimeException convertResolverConstructorError(ImmutableProp prop, Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        return new ModelException("Cannot create resolver \"" + ((Transient)prop.getAnnotation(Transient.class)).value() + "\" for property \"" + prop + "\"", throwable);
    }

    static {
        Class<?> kSqlClientClass = null;
        Class<?> kSqlClientImplClass = null;
        Constructor<?> kSqlClientImplConstructor = null;
        try {
            kSqlClientClass = Class.forName("org.babyfish.jimmer.sql.kt.KSqlClient");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (kSqlClientClass != null) {
            try {
                kSqlClientImplClass = Class.forName("org.babyfish.jimmer.sql.kt.impl.KSqlClientImpl");
                kSqlClientImplConstructor = kSqlClientImplClass.getConstructor(JSqlClient.class);
            }
            catch (ClassNotFoundException | NoSuchMethodException ex) {
                throw new AssertionError("Internal bug", ex);
            }
        }
        K_SQL_CLIENT_CLASS = kSqlClientClass;
        K_SQL_CLIENT_IMPL_CONSTRUCTOR = kSqlClientImplConstructor;
    }
}

