/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast;

import java.util.function.Consumer;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.impl.CompositePredicate;
import org.babyfish.jimmer.sql.ast.impl.SqlExpressionContext;
import org.babyfish.jimmer.sql.ast.impl.SqlExpressions;
import org.jetbrains.annotations.Nullable;

public interface Predicate
extends Expression<Boolean> {
    public Predicate and(@Nullable Predicate var1);

    public Predicate or(@Nullable Predicate var1);

    public Predicate not();

    @Nullable
    public static Predicate and(Predicate ... predicates) {
        return CompositePredicate.and(predicates);
    }

    @Nullable
    public static Predicate or(Predicate ... predicates) {
        return CompositePredicate.or(predicates);
    }

    @Nullable
    public static Predicate not(@Nullable Predicate predicate) {
        if (predicate == null) {
            return null;
        }
        return predicate.not();
    }

    public static Predicate sql(String sql) {
        return (Predicate)SqlExpressions.of(Boolean.class, sql, null);
    }

    public static Predicate sql(String sql, Expression<?> expression, Object ... values) {
        return (Predicate)SqlExpressions.of(Boolean.class, sql, new Expression[]{expression}, values);
    }

    public static Predicate sql(String sql, Expression<?>[] expressions, Object ... values) {
        return (Predicate)SqlExpressions.of(Boolean.class, sql, expressions, values);
    }

    public static Predicate sql(String sql, Consumer<SqlExpressionContext> block) {
        return (Predicate)SqlExpressions.of(Boolean.class, sql, block);
    }
}

