/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.fetcher.FieldFilter;
import org.babyfish.jimmer.sql.fetcher.RecursionStrategy;
import org.babyfish.jimmer.sql.fetcher.RecursiveListFieldConfig;
import org.babyfish.jimmer.sql.fetcher.impl.DefaultRecursionStrategy;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImpl;

class FieldConfigImpl<E, T extends Table<E>>
implements RecursiveListFieldConfig<E, T> {
    private ImmutableProp prop;
    private FetcherImpl<?> childFetcher;
    private FieldFilter<T> filter;
    private int batchSize;
    private int limit = Integer.MAX_VALUE;
    private int offset = 0;
    private RecursionStrategy<E> recursionStrategy;

    FieldConfigImpl(ImmutableProp prop, FetcherImpl<?> childFetcher) {
        if (childFetcher != null && !prop.isAssociation(TargetLevel.ENTITY)) {
            throw new IllegalArgumentException("'" + prop + "' is not entity association");
        }
        this.prop = prop;
        this.childFetcher = childFetcher;
    }

    @Override
    public RecursiveListFieldConfig<E, T> filter(FieldFilter<T> filter) {
        if (filter != null && this.prop.isReference(TargetLevel.ENTITY) && !this.prop.isNullable()) {
            throw new IllegalArgumentException("Cannot set filter for non-null one-to-one/many-to-one property \"" + this.prop + "\"");
        }
        this.filter = filter;
        return this;
    }

    @Override
    public RecursiveListFieldConfig<E, T> batch(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("batchSize cannot be less than 0");
        }
        this.batchSize = size;
        return this;
    }

    @Override
    public RecursiveListFieldConfig<E, T> limit(int limit, int offset) {
        if (!this.prop.isReferenceList(TargetLevel.ENTITY)) {
            throw new IllegalArgumentException("Cannot set limit because current property \"" + this.prop + "\" is not list property");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("'limit' can not be less than 0");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("'offset' can not be less than 0");
        }
        if (limit > Integer.MAX_VALUE - offset) {
            throw new IllegalArgumentException("'limit' > Int.MAX_VALUE - offset");
        }
        this.limit = limit;
        this.offset = offset;
        return this;
    }

    @Override
    public RecursiveListFieldConfig<E, T> depth(int depth) {
        return this.recursive((RecursionStrategy)DefaultRecursionStrategy.of(depth));
    }

    @Override
    public RecursiveListFieldConfig<E, T> recursive() {
        return this.recursive((RecursionStrategy)DefaultRecursionStrategy.of(Integer.MAX_VALUE));
    }

    @Override
    public RecursiveListFieldConfig<E, T> recursive(RecursionStrategy<E> strategy) {
        if (!this.prop.getDeclaringType().getJavaClass().isAssignableFrom(this.prop.getTargetType().getJavaClass())) {
            throw new IllegalArgumentException("Cannot set recursive strategy because current property \"" + this.prop + "\" is not recursive property");
        }
        this.recursionStrategy = strategy;
        return this;
    }

    ImmutableProp getProp() {
        return this.prop;
    }

    FetcherImpl<?> getChildFetcher() {
        return this.childFetcher;
    }

    FieldFilter<T> getFilter() {
        return this.filter;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    int getLimit() {
        return this.limit;
    }

    int getOffset() {
        return this.offset;
    }

    RecursionStrategy<E> getRecursionStrategy() {
        return this.recursionStrategy;
    }
}

