/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.chain;

import java.util.ArrayList;
import java.util.List;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.chain.ChainCacheImpl;
import org.babyfish.jimmer.sql.cache.chain.LoadingBinder;
import org.babyfish.jimmer.sql.cache.chain.ParameterizedChainCacheImpl;
import org.babyfish.jimmer.sql.cache.chain.SimpleBinder;

public class ChainCacheBuilder<K, V> {
    private final List<Object> binders = new ArrayList<Object>();
    private Boolean hasParameterizedBinder = null;

    public ChainCacheBuilder<K, V> add(LoadingBinder<K, V> binder) {
        if (binder != null) {
            if (Boolean.TRUE.equals(this.hasParameterizedBinder)) {
                throw new IllegalArgumentException("Parameterized binder and normal binder cannot be mixed");
            }
            this.hasParameterizedBinder = false;
            this.binders.add(binder);
        }
        return this;
    }

    public ChainCacheBuilder<K, V> add(LoadingBinder.Parameterized<K, V> binder) {
        if (binder != null) {
            if (Boolean.FALSE.equals(this.hasParameterizedBinder)) {
                throw new IllegalArgumentException("Parameterized binder and normal binder cannot be mixed");
            }
            this.hasParameterizedBinder = true;
            this.binders.add(binder);
        }
        return this;
    }

    public ChainCacheBuilder<K, V> add(SimpleBinder<K, V> binder) {
        if (binder != null) {
            boolean isParameterized = binder instanceof SimpleBinder.Parameterized;
            if (this.hasParameterizedBinder != null && !this.hasParameterizedBinder.equals(isParameterized)) {
                throw new IllegalArgumentException("Parameterized binder and normal binder cannot be mixed");
            }
            this.hasParameterizedBinder = isParameterized;
            this.binders.add(binder);
        }
        return this;
    }

    public Cache<K, V> build() {
        List<Object> binders = this.binders;
        if (binders.isEmpty()) {
            return null;
        }
        if (this.hasParameterizedBinder.booleanValue()) {
            return new ParameterizedChainCacheImpl(binders);
        }
        return new ChainCacheImpl(binders);
    }
}

