/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql;

import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.Static;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.ast.mutation.AbstractEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.BatchEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.BatchSaveResult;
import org.babyfish.jimmer.sql.ast.mutation.DeleteCommand;
import org.babyfish.jimmer.sql.ast.mutation.DeleteResult;
import org.babyfish.jimmer.sql.ast.mutation.SimpleEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.SimpleSaveResult;
import org.babyfish.jimmer.sql.ast.query.Example;
import org.babyfish.jimmer.sql.fetcher.Fetcher;

public interface Entities {
    public Entities forUpdate();

    public Entities forConnection(Connection var1);

    public <E> E findById(Class<E> var1, Object var2);

    public <E> List<E> findByIds(Class<E> var1, Collection<?> var2);

    public <ID, E> Map<ID, E> findMapByIds(Class<E> var1, Collection<ID> var2);

    public <E> E findById(Fetcher<E> var1, Object var2);

    public <E> List<E> findByIds(Fetcher<E> var1, Collection<?> var2);

    public <ID, E> Map<ID, E> findMapByIds(Fetcher<E> var1, Collection<ID> var2);

    public <E> List<E> findAll(Class<E> var1, TypedProp.Scalar<?, ?> ... var2);

    public <E> List<E> findAll(Fetcher<E> var1, TypedProp.Scalar<?, ?> ... var2);

    public <E> List<E> findByExample(Example<E> var1, TypedProp.Scalar<?, ?> ... var2);

    public <E> List<E> findByExample(Example<E> var1, Fetcher<E> var2, TypedProp.Scalar<?, ?> ... var3);

    public <E, S extends Static<E>> S findStaticObjectById(Class<S> var1, Object var2);

    public <E, S extends Static<E>> List<S> findStaticObjectsByIds(Class<S> var1, Collection<?> var2);

    public <ID, E, S extends Static<E>> Map<ID, S> findStaticObjectMapByIds(Class<S> var1, Collection<ID> var2);

    public <E, S extends Static<E>> List<S> findAllStaticObjects(Class<S> var1, TypedProp.Scalar<?, ?> ... var2);

    public <E, S extends Static<E>> List<S> findStaticObjectsByExample(Class<S> var1, Example<E> var2, TypedProp.Scalar<?, ?> ... var3);

    default public <E> SimpleSaveResult<E> save(E entity) {
        return (SimpleSaveResult)this.saveCommand(entity).execute();
    }

    default public <E> SimpleSaveResult<E> save(E entity, boolean autoAttachingAll) {
        return (SimpleSaveResult)this.saveCommand(entity, autoAttachingAll).execute();
    }

    public <E> SimpleEntitySaveCommand<E> saveCommand(E var1);

    default public <E> SimpleEntitySaveCommand<E> saveCommand(E entity, boolean autoAttachAll) {
        SimpleEntitySaveCommand<E> command = this.saveCommand(entity);
        if (!autoAttachAll) {
            return command;
        }
        return command.configure(AbstractEntitySaveCommand.Cfg::setAutoAttachingAll);
    }

    default public <E> BatchSaveResult<E> batchSave(Collection<E> entities) {
        return (BatchSaveResult)this.batchSaveCommand(entities).execute();
    }

    default public <E> BatchSaveResult<E> batchSave(Collection<E> entities, boolean autoAttachingAll) {
        return (BatchSaveResult)this.batchSaveCommand(entities, autoAttachingAll).execute();
    }

    public <E> BatchEntitySaveCommand<E> batchSaveCommand(Collection<E> var1);

    default public <E> BatchEntitySaveCommand<E> batchSaveCommand(Collection<E> entities, boolean autoAttachAll) {
        BatchEntitySaveCommand<E> command = this.batchSaveCommand(entities);
        if (!autoAttachAll) {
            return command;
        }
        return command.configure(AbstractEntitySaveCommand.Cfg::setAutoAttachingAll);
    }

    default public DeleteResult delete(Class<?> entityType, Object id) {
        return (DeleteResult)this.deleteCommand(entityType, id).execute();
    }

    public DeleteCommand deleteCommand(Class<?> var1, Object var2);

    default public DeleteResult batchDelete(Class<?> entityType, Collection<?> ids) {
        return (DeleteResult)this.batchDeleteCommand(entityType, ids).execute();
    }

    public DeleteCommand batchDeleteCommand(Class<?> var1, Collection<?> var2);
}

