/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.loader.impl;

import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.Executable;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.fetcher.FieldFilter;
import org.babyfish.jimmer.sql.loader.FilterableListLoader;
import org.babyfish.jimmer.sql.loader.impl.BatchCommand;
import org.babyfish.jimmer.sql.loader.impl.SingleCommand;
import org.jetbrains.annotations.NotNull;

class ListLoaderImpl<SE, TE, TT extends Table<TE>>
implements FilterableListLoader<SE, TE, TT> {
    private final JSqlClient sqlClient;
    private Connection con;
    private final ImmutableProp prop;
    private final FieldFilter<?> filter;

    public ListLoaderImpl(JSqlClient sqlClient, ImmutableProp prop) {
        this(sqlClient, null, prop, null);
    }

    private ListLoaderImpl(JSqlClient sqlClient, Connection con, ImmutableProp prop, FieldFilter<?> filter) {
        this.sqlClient = sqlClient;
        this.con = con;
        this.prop = prop;
        this.filter = filter;
    }

    @Override
    public FilterableListLoader<SE, TE, TT> forConnection(Connection con) {
        if (this.con == con) {
            return this;
        }
        return new ListLoaderImpl<SE, TE, TT>(this.sqlClient, con, this.prop, this.filter);
    }

    @Override
    public FilterableListLoader<SE, TE, TT> forFilter(FieldFilter<TT> filter) {
        if (this.filter == filter) {
            return this;
        }
        return new ListLoaderImpl<SE, TE, TT>(this.sqlClient, this.con, this.prop, filter);
    }

    @Override
    @NotNull
    public Executable<List<TE>> loadCommand(@NotNull SE source, int limit, int offset) {
        if (source instanceof Collection) {
            throw new IllegalArgumentException("source cannot be collection, do you want to call 'batchLoadCommand'?");
        }
        return new SingleCommand<List<TE>>(this.sqlClient, this.con, this.prop, this.filter, limit, offset, (ImmutableSpi)source, Collections.emptyList());
    }

    @Override
    @NotNull
    public Executable<Map<SE, List<TE>>> batchLoadCommand(@NotNull Collection<SE> sources) {
        return new BatchCommand(this.sqlClient, this.con, this.prop, this.filter, sources, Collections.emptyList());
    }
}

