/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.query;

import java.util.Objects;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.query.NullOrderMode;
import org.babyfish.jimmer.sql.ast.query.OrderMode;

public class Order {
    private final Expression<?> expression;
    private final OrderMode orderMode;
    private final NullOrderMode nullOrderMode;

    public Order(Expression<?> expression, OrderMode orderMode, NullOrderMode nullOrderMode) {
        this.expression = Objects.requireNonNull(expression);
        this.orderMode = Objects.requireNonNull(orderMode);
        this.nullOrderMode = Objects.requireNonNull(nullOrderMode);
    }

    public Expression<?> getExpression() {
        return this.expression;
    }

    public OrderMode getOrderMode() {
        return this.orderMode;
    }

    public NullOrderMode getNullOrderMode() {
        return this.nullOrderMode;
    }

    public Order nullsFirst() {
        return new Order(this.expression, this.orderMode, NullOrderMode.NULLS_FIRST);
    }

    public Order nullsLast() {
        return new Order(this.expression, this.orderMode, NullOrderMode.NULLS_LAST);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Order order = (Order)o;
        return this.expression.equals(order.expression) && this.orderMode == order.orderMode && this.nullOrderMode == order.nullOrderMode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.expression, this.orderMode, this.nullOrderMode});
    }

    public String toString() {
        return "Order{expression=" + this.expression + ", orderMode=" + (Object)((Object)this.orderMode) + ", nullOrderMode=" + (Object)((Object)this.nullOrderMode) + '}';
    }
}

