/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event;

import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.jetbrains.annotations.Nullable;

public class ChangedRef<T> {
    private final T oldValue;
    private final T newValue;

    public ChangedRef(T oldValue, T newValue) {
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Nullable
    public T getOldValue() {
        return this.oldValue;
    }

    @Nullable
    public T getNewValue() {
        return this.newValue;
    }

    public <X> ChangedRef<X> toIdRef() {
        ImmutableType type;
        if (this.oldValue instanceof ImmutableSpi) {
            type = ((ImmutableSpi)this.oldValue).__type();
        } else if (this.newValue instanceof ImmutableSpi) {
            type = ((ImmutableSpi)this.newValue).__type();
        } else {
            throw new IllegalStateException("The current `ChangedRef` is not object pair");
        }
        int idPropId = type.getIdProp().getId();
        return new ChangedRef<Object>((this.oldValue != null ? ((ImmutableSpi)this.oldValue).__get(idPropId) : null), (this.newValue != null ? ((ImmutableSpi)this.newValue).__get(idPropId) : null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedRef that = (ChangedRef)o;
        return Objects.equals(this.oldValue, that.oldValue) && Objects.equals(this.newValue, that.newValue);
    }

    public int hashCode() {
        return Objects.hash(this.oldValue, this.newValue);
    }

    public String toString() {
        return "ChangedRef{oldValue=" + this.oldValue + ", newValue=" + this.newValue + '}';
    }
}

