/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;

public class EnumProviderBuilder<E extends Enum<E>, S> {
    private Class<E> enumType;
    private Class<S> sqlType;
    private Function<E, S> defaultSqlValueMapper;
    private Map<E, S> sqlMap = new HashMap<E, S>();

    public static <E extends Enum<E>, S> EnumProviderBuilder<E, S> of(Class<E> enumType, Class<S> sqlType, Function<E, S> defaultSqlValueMapper) {
        return new EnumProviderBuilder<E, S>(enumType, sqlType, defaultSqlValueMapper);
    }

    private EnumProviderBuilder(Class<E> enumType, Class<S> sqlType, Function<E, S> defaultSqlValueMapper) {
        this.enumType = enumType;
        this.sqlType = sqlType;
        this.defaultSqlValueMapper = defaultSqlValueMapper;
    }

    public EnumProviderBuilder<E, S> map(E enumValue, S sqlValue) {
        if (this.sqlMap.containsValue(enumValue)) {
            throw new IllegalStateException("'${enumValue}' has been mapped");
        }
        this.sqlMap.put(enumValue, sqlValue);
        return this;
    }

    public EnumProvider<E, S> build() {
        HashMap<E, S> sqlMap = new HashMap<E, S>(this.sqlMap);
        for (Enum enumValue : (Enum[])this.enumType.getEnumConstants()) {
            sqlMap.computeIfAbsent(enumValue, this.defaultSqlValueMapper);
        }
        HashMap enumMap = new HashMap();
        for (Map.Entry entry : sqlMap.entrySet()) {
            Enum conflictEnum = enumMap.put(entry.getValue(), (Enum)entry.getKey());
            if (conflictEnum == null) continue;
            throw new IllegalStateException("Both '" + entry.getKey() + "' and '" + conflictEnum + "' are mapped as '" + entry.getValue() + "'");
        }
        return new EnumProvider<E, S>(this.enumType, this.sqlType, enumMap, sqlMap);
    }

    private static class EnumProvider<E extends Enum<E>, S>
    extends ScalarProvider<E, S> {
        private final Map<S, E> enumMap;
        private final Map<E, S> sqlMap;

        public EnumProvider(Class<E> enumType, Class<S> sqlType, Map<S, E> enumMap, Map<E, S> sqlMap) {
            super(enumType, sqlType);
            this.enumMap = enumMap;
            this.sqlMap = sqlMap;
        }

        @Override
        public E toScalar(S sqlValue) {
            Enum scalarValue = (Enum)this.enumMap.get(sqlValue);
            if (scalarValue == null) {
                throw new IllegalArgumentException("Cannot resolve '$" + this.getScalarType().getName() + "' by the value '" + sqlValue + "'");
            }
            return (E)scalarValue;
        }

        @Override
        public S toSql(E enumValue) {
            S sqlValue = this.sqlMap.get(enumValue);
            if (sqlValue == null) {
                throw new AssertionError((Object)"Internal bug: Enum can be converted to sql value absolutely");
            }
            return sqlValue;
        }
    }
}

