/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.filter.impl;

import java.util.Arrays;
import java.util.Objects;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractMutableQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.SortableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.query.MutableSubQuery;
import org.babyfish.jimmer.sql.ast.query.Order;
import org.babyfish.jimmer.sql.ast.query.Sortable;
import org.babyfish.jimmer.sql.ast.table.AssociationTable;
import org.babyfish.jimmer.sql.ast.table.Props;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.ast.table.spi.UntypedJoinDisabledTableProxy;
import org.babyfish.jimmer.sql.filter.FilterArgs;
import org.jetbrains.annotations.NotNull;

public class FilterArgsImpl<P extends Props>
implements FilterArgs<P> {
    private static final String JOIN_DISABLED_REASON = "it is not allowed by cacheable filter";
    private final SortableImplementor sortable;
    private final P props;
    private boolean sorted;

    public FilterArgsImpl(SortableImplementor sortable, Props props, boolean forCache) {
        this.sortable = sortable;
        if (forCache) {
            props = props instanceof TableImplementor ? new UntypedJoinDisabledTableProxy((TableImplementor)((Object)props), JOIN_DISABLED_REASON) : ((TableProxy)props).__disableJoin(JOIN_DISABLED_REASON);
        }
        this.props = props;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    @Override
    @NotNull
    public P getTable() {
        return this.props;
    }

    @Override
    public Sortable where(Predicate ... predicates) {
        return this.sortable.where(predicates);
    }

    @Override
    public Sortable orderBy(Expression<?> ... expressions) {
        if (!this.sorted) {
            this.sorted = Arrays.stream(expressions).anyMatch(Objects::nonNull);
        }
        return this.sortable.orderBy(expressions);
    }

    @Override
    public Sortable orderBy(Order ... orders) {
        if (!this.sorted) {
            this.sorted = Arrays.stream(orders).anyMatch(Objects::nonNull);
        }
        return this.sortable.orderBy(orders);
    }

    @Override
    public MutableSubQuery createSubQuery(TableProxy<?> table) {
        return this.sortable.createSubQuery(table);
    }

    @Override
    public <SE, ST extends TableEx<SE>, TE, TT extends TableEx<TE>> MutableSubQuery createAssociationSubQuery(AssociationTable<SE, ST, TE, TT> table) {
        return this.sortable.createAssociationSubQuery(table);
    }

    public AbstractMutableQueryImpl unwrap() {
        return (AbstractMutableQueryImpl)this.sortable;
    }
}

