/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import org.babyfish.jimmer.sql.ast.ComparableExpression;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.StringExpression;
import org.babyfish.jimmer.sql.ast.impl.AbstractExpression;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ComparableExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.NumericExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.StringExpressionImplementor;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

class Literals {
    Literals() {
    }

    public static StringExpression string(String value) {
        return new Str(value);
    }

    public static <N extends Number> NumericExpression<N> number(N value) {
        return new Num<N>(value);
    }

    public static <T extends Comparable<?>> ComparableExpression<T> comparable(T value) {
        return new Cmp<T>(value);
    }

    public static <T> Expression<T> any(T value) {
        if (value instanceof String) {
            return Literals.string((String)value);
        }
        if (value instanceof Number) {
            return Literals.number((Number)((Object)((Comparable)value)));
        }
        if (value instanceof Comparable) {
            return Literals.comparable((Comparable)value);
        }
        return new Any<T>(value);
    }

    private static class Str
    extends Any<String>
    implements StringExpressionImplementor {
        public Str(String value) {
            super(value);
        }
    }

    private static class Num<N extends Number>
    extends Any<N>
    implements NumericExpressionImplementor<N> {
        public Num(N value) {
            super(value);
        }
    }

    private static class Cmp<T extends Comparable<?>>
    extends Any<T>
    implements ComparableExpressionImplementor<T> {
        public Cmp(T value) {
            super(value);
        }
    }

    private static class Any<T>
    extends AbstractExpression<T> {
        private T value;

        public Any(T value) {
            if (value == null) {
                throw new IllegalArgumentException("The value of literal expression cannot be null");
            }
            this.value = value;
        }

        @Override
        public Class<T> getType() {
            return this.value.getClass();
        }

        @Override
        public void accept(@NotNull AstVisitor visitor) {
        }

        @Override
        public void renderTo(@NotNull SqlBuilder builder) {
            builder.variable(this.value);
        }

        @Override
        public int precedence() {
            return 0;
        }
    }
}

