/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import java.sql.Connection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.RecursionStrategy;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherTask;
import org.babyfish.jimmer.sql.fetcher.impl.FetchingCache;

class FetcherContext {
    private static final ThreadLocal<FetcherContext> FETCHER_CONTEXT_LOCAL = new ThreadLocal();
    private JSqlClient sqlClient;
    private Connection con;
    private FetchingCache cache = new FetchingCache();
    private Map<Field, FetcherTask> taskMap = new LinkedHashMap<Field, FetcherTask>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void using(JSqlClient sqlClient, Connection con, BiConsumer<FetcherContext, Boolean> block) {
        FetcherContext ctx = FETCHER_CONTEXT_LOCAL.get();
        if (ctx != null) {
            block.accept(ctx, false);
        } else {
            ctx = new FetcherContext(sqlClient, con);
            FETCHER_CONTEXT_LOCAL.set(ctx);
            try {
                block.accept(ctx, true);
            }
            finally {
                FETCHER_CONTEXT_LOCAL.remove();
            }
        }
    }

    private FetcherContext(JSqlClient sqlClient, Connection con) {
        this.sqlClient = sqlClient;
        this.con = con;
    }

    public void add(Fetcher<?> fetcher, DraftSpi draft) {
        for (Field field : fetcher.getFieldMap().values()) {
            if (field.isSimpleField() && this.sqlClient.getFilters().getFilter(field.getProp().getTargetType()) == null) continue;
            RecursionStrategy<?> recursionStrategy = field.getRecursionStrategy();
            if (recursionStrategy != null && !recursionStrategy.isRecursive(new RecursionStrategy.Args<DraftSpi>(draft, 0))) {
                return;
            }
            FetcherTask task = this.taskMap.computeIfAbsent(field, it -> new FetcherTask(this.cache, this.sqlClient, this.con, field));
            task.add(draft);
        }
    }

    public void addAll(Fetcher<?> fetcher, Collection<DraftSpi> drafts) {
        for (DraftSpi draft : drafts) {
            this.add(fetcher, draft);
        }
    }

    public void execute() {
        while (!this.taskMap.isEmpty()) {
            Iterator<Map.Entry<Field, FetcherTask>> itr = this.taskMap.entrySet().iterator();
            Map.Entry<Field, FetcherTask> e = itr.next();
            if (!e.getValue().execute()) continue;
            this.taskMap.remove(e.getKey());
        }
    }
}

