/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.query;

import java.util.function.Supplier;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.query.Filterable;
import org.babyfish.jimmer.sql.ast.query.NullOrderMode;
import org.babyfish.jimmer.sql.ast.query.Order;
import org.babyfish.jimmer.sql.ast.query.OrderMode;

public interface Sortable
extends Filterable {
    @Override
    public Sortable where(Predicate ... var1);

    @Override
    default public Sortable whereIf(boolean condition, Predicate predicates) {
        if (condition) {
            this.where(predicates);
        }
        return this;
    }

    @Override
    default public Sortable whereIf(boolean condition, Supplier<Predicate> block) {
        if (condition) {
            this.where(block.get());
        }
        return this;
    }

    default public Sortable orderBy(Expression<?> ... expressions) {
        Order[] orders = new Order[expressions.length];
        for (int i = orders.length - 1; i >= 0; --i) {
            Expression<?> expression = expressions[i];
            if (expression == null) continue;
            orders[i] = new Order(expression, OrderMode.ASC, NullOrderMode.UNSPECIFIED);
        }
        return this.orderBy(orders);
    }

    default public Sortable orderByIf(boolean condition, Expression<?> ... expressions) {
        if (condition) {
            this.orderBy(expressions);
        }
        return this;
    }

    public Sortable orderBy(Order ... var1);

    default public Sortable orderByIf(boolean condition, Order ... orders) {
        if (condition) {
            this.orderBy(orders);
        }
        return this;
    }
}

