/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.query.SortableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableRowCountDestructive;
import org.babyfish.jimmer.sql.ast.query.MutableQuery;
import org.babyfish.jimmer.sql.ast.query.Order;
import org.babyfish.jimmer.sql.ast.query.OrderMode;
import org.babyfish.jimmer.sql.ast.query.TypedSubQuery;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

public abstract class AbstractMutableQueryImpl
extends AbstractMutableStatementImpl
implements MutableQuery,
SortableImplementor {
    private final List<Expression<?>> groupByExpressions = new ArrayList();
    private List<Predicate> havingPredicates = new ArrayList<Predicate>();
    private final List<Order> orders = new ArrayList<Order>();
    private int subQueryDisabledCount = 0;

    protected AbstractMutableQueryImpl(JSqlClient sqlClient, ImmutableType immutableType) {
        super(sqlClient, immutableType);
    }

    protected AbstractMutableQueryImpl(JSqlClient sqlClient, TableProxy<?> table) {
        super(sqlClient, table);
    }

    @Override
    public AbstractMutableQueryImpl where(Predicate ... predicates) {
        return (AbstractMutableQueryImpl)super.where(predicates);
    }

    @Override
    public AbstractMutableQueryImpl whereIf(boolean condition, Predicate predicates) {
        if (condition) {
            this.where(predicates);
        }
        return this;
    }

    @Override
    public AbstractMutableQueryImpl whereIf(boolean condition, Supplier<Predicate> block) {
        if (condition) {
            this.where(block.get());
        }
        return this;
    }

    @Override
    public AbstractMutableQueryImpl groupBy(Expression<?> ... expressions) {
        this.validateMutable();
        for (Expression<?> expression : expressions) {
            if (expression == null) continue;
            this.groupByExpressions.add(expression);
        }
        return this;
    }

    @Override
    public AbstractMutableQueryImpl having(Predicate ... predicates) {
        this.validateMutable();
        for (Predicate predicate : predicates) {
            if (predicate == null) continue;
            this.havingPredicates.add(predicate);
        }
        return this;
    }

    @Override
    public AbstractMutableQueryImpl orderBy(Expression<?> ... expressions) {
        this.validateMutable();
        return (AbstractMutableQueryImpl)MutableQuery.super.orderBy((Expression[])expressions);
    }

    @Override
    public AbstractMutableQueryImpl orderByIf(boolean condition, Expression<?> ... expressions) {
        return (AbstractMutableQueryImpl)MutableQuery.super.orderByIf(condition, (Expression[])expressions);
    }

    @Override
    public AbstractMutableQueryImpl orderBy(Order ... orders) {
        for (Order order : orders) {
            if (order == null) continue;
            this.orders.add(order);
        }
        return this;
    }

    @Override
    public AbstractMutableQueryImpl orderByIf(boolean condition, Order ... orders) {
        return (AbstractMutableQueryImpl)MutableQuery.super.orderByIf(condition, orders);
    }

    @Override
    protected void onFrozen() {
        this.havingPredicates = AbstractMutableQueryImpl.mergePredicates(this.havingPredicates);
        super.onFrozen();
    }

    @Override
    public void disableSubQuery() {
        ++this.subQueryDisabledCount;
    }

    @Override
    public void enableSubQuery() {
        --this.subQueryDisabledCount;
    }

    @Override
    public boolean isSubQueryDisabled() {
        return this.subQueryDisabledCount != 0;
    }

    void accept(AstVisitor visitor, List<Selection<?>> overriddenSelections, boolean withoutSortingAndPaging) {
        Object ignoredVisitor;
        Predicate havingPredicate;
        Predicate predicate = this.getPredicate();
        Predicate predicate2 = havingPredicate = this.havingPredicates.isEmpty() ? null : this.havingPredicates.get(0);
        if (this.groupByExpressions.isEmpty() && !this.havingPredicates.isEmpty()) {
            throw new IllegalStateException("Having clause cannot be used without group clause");
        }
        if (predicate != null) {
            ((Ast)((Object)predicate)).accept(visitor);
        }
        for (Expression<?> expression : this.groupByExpressions) {
            ((Ast)((Object)expression)).accept(visitor);
        }
        if (havingPredicate != null) {
            ((Ast)((Object)havingPredicate)).accept(visitor);
        }
        AstContext astContext = visitor.getAstContext();
        if (withoutSortingAndPaging) {
            ignoredVisitor = new UseJoinOfIgnoredClauseVisitor(astContext);
            for (Order order : this.orders) {
                ((Ast)((Object)order.getExpression())).accept((AstVisitor)ignoredVisitor);
            }
        } else {
            for (Order order : this.orders) {
                ((Ast)((Object)order.getExpression())).accept(visitor);
            }
        }
        if (overriddenSelections != null) {
            ignoredVisitor = new UseJoinOfIgnoredClauseVisitor(astContext);
            for (Selection selection : overriddenSelections) {
                Ast.from(selection, astContext).accept((AstVisitor)ignoredVisitor);
            }
        }
    }

    void renderTo(SqlBuilder builder, boolean withoutSortingAndPaging) {
        String separator;
        Predicate predicate = this.getPredicate();
        Predicate havingPredicate = this.havingPredicates.isEmpty() ? null : this.havingPredicates.get(0);
        TableImplementor<?> tableImplementor = this.getTableImplementor();
        tableImplementor.renderTo(builder);
        if (predicate != null) {
            builder.sql(" where ");
            ((Ast)((Object)predicate)).renderTo(builder);
        }
        if (!this.groupByExpressions.isEmpty()) {
            separator = " group by ";
            for (Expression<?> expression : this.groupByExpressions) {
                builder.sql(separator);
                ((Ast)((Object)expression)).renderTo(builder);
                separator = ", ";
            }
        }
        if (havingPredicate != null) {
            builder.sql(" having ");
            ((Ast)((Object)havingPredicate)).renderTo(builder);
        }
        if (!withoutSortingAndPaging && !this.orders.isEmpty()) {
            separator = " order by ";
            for (Order order : this.orders) {
                builder.sql(separator);
                ((Ast)((Object)order.getExpression())).renderTo(builder);
                if (order.getOrderMode() == OrderMode.ASC) {
                    builder.sql(" asc");
                } else {
                    builder.sql(" desc");
                }
                switch (order.getNullOrderMode()) {
                    case NULLS_FIRST: {
                        builder.sql(" nulls first");
                    }
                    case NULLS_LAST: {
                        builder.sql(" nulls last");
                    }
                }
                separator = ", ";
            }
        }
    }

    protected boolean isGroupByClauseUsed() {
        return !this.groupByExpressions.isEmpty();
    }

    private static class UseJoinOfIgnoredClauseVisitor
    extends AstVisitor {
        public UseJoinOfIgnoredClauseVisitor(AstContext ctx) {
            super(ctx);
        }

        @Override
        public boolean visitSubQuery(TypedSubQuery<?> subQuery) {
            return false;
        }

        @Override
        public void visitTableReference(TableImplementor<?> table, ImmutableProp prop) {
            this.handle(table, prop != null && prop.isId());
        }

        private void handle(TableImplementor<?> table, boolean isId) {
            if (table.getDestructive() != TableRowCountDestructive.NONE) {
                if (isId) {
                    this.getAstContext().useTableId(table);
                    this.use(table.getParent());
                } else {
                    this.use(table);
                }
            }
        }

        private void use(TableImplementor<?> table) {
            if (table != null) {
                this.getAstContext().useTable(table);
                this.use(table.getParent());
            }
        }
    }
}

