/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event;

import java.sql.Connection;
import java.util.Objects;
import org.babyfish.jimmer.lang.Ref;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.event.ChangedRef;
import org.babyfish.jimmer.sql.meta.Column;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityEvent<E> {
    private final Object id;
    private final E oldEntity;
    private final E newEntity;
    private final Connection con;
    private final Object reason;

    public EntityEvent(E oldEntity, E newEntity, Connection con, Object reason) {
        if (oldEntity == null && newEntity == null) {
            throw new IllegalArgumentException("Both oldEntity and newEntity are null");
        }
        if (oldEntity != null && !(oldEntity instanceof ImmutableSpi)) {
            throw new IllegalArgumentException("oldEntity is not immutable object");
        }
        if (newEntity != null && !(newEntity instanceof ImmutableSpi)) {
            throw new IllegalArgumentException("newEntity is not immutable object");
        }
        ImmutableSpi oe = (ImmutableSpi)oldEntity;
        ImmutableSpi ne = (ImmutableSpi)newEntity;
        if (oe != null && ne != null && oe.__type() != ne.__type()) {
            throw new IllegalArgumentException("oldEntity and newEntity must belong to same type");
        }
        int idPropId = (oe != null ? oe : ne).__type().getIdProp().getId();
        Object oldId = null;
        if (oe != null && oe.__isLoaded(idPropId)) {
            oldId = oe.__get(idPropId);
        }
        Object newId = null;
        if (ne != null && ne.__isLoaded(idPropId)) {
            newId = ne.__get(idPropId);
        }
        if (oldId == null && newId == null) {
            throw new IllegalStateException("Id is not specified");
        }
        if (oldId != null && newId != null && !oldId.equals(newId)) {
            throw new IllegalStateException("Conflict ids in old entity and new entity");
        }
        this.id = oldId != null ? oldId : newId;
        this.oldEntity = oldEntity;
        this.newEntity = newEntity;
        this.con = con;
        this.reason = reason;
    }

    @Nullable
    public E getOldEntity() {
        return this.oldEntity;
    }

    @Nullable
    public E getNewEntity() {
        return this.newEntity;
    }

    @NotNull
    public Object getId() {
        return this.id;
    }

    @Nullable
    public Connection getConnection() {
        return this.con;
    }

    @Nullable
    public Object getReason() {
        return this.reason;
    }

    @NotNull
    public ImmutableType getImmutableType() {
        E oe = this.oldEntity;
        if (oe != null) {
            return ((ImmutableSpi)oe).__type();
        }
        return ((ImmutableSpi)this.newEntity).__type();
    }

    @NotNull
    public Type getType() {
        if (this.oldEntity == null) {
            return Type.INSERT;
        }
        if (this.newEntity == null) {
            return Type.DELETE;
        }
        return Type.UPDATE;
    }

    @Nullable
    public <T> Ref<T> getUnchangedFieldRef(ImmutableProp prop) {
        return this.getUnchangedFieldRef(prop.getId());
    }

    @Nullable
    public <T> Ref<T> getUnchangedFieldRef(TypedProp<?, ?> prop) {
        return this.getUnchangedFieldRef(prop.unwrap().getId());
    }

    @Nullable
    public <T> Ref<T> getUnchangedFieldRef(int propId) {
        Object newValue;
        boolean newLoaded;
        ImmutableProp prop = this.getImmutableType().getProp(propId);
        if (!(prop.getStorage() instanceof Column)) {
            throw new IllegalArgumentException("Cannot get the unchanged the value of \"" + prop + "\" because it is not a property mapped by column");
        }
        ImmutableSpi oe = (ImmutableSpi)this.oldEntity;
        ImmutableSpi ne = (ImmutableSpi)this.newEntity;
        boolean oldLoaded = oe != null && oe.__isLoaded(propId);
        boolean bl = newLoaded = ne != null && ne.__isLoaded(propId);
        if (!oldLoaded && !newLoaded) {
            throw new IllegalStateException("Cannot get the unchanged the value of \"" + prop + "\" from neither oldEntity nor newEntity");
        }
        if (!oldLoaded) {
            return Ref.of((Object)ne.__get(propId));
        }
        if (!newLoaded) {
            return Ref.of((Object)oe.__get(propId));
        }
        Object oldValue = oe.__get(propId);
        if (this.valueEqual(prop, oldValue, newValue = ne.__get(propId))) {
            return Ref.of((Object)oldValue);
        }
        return null;
    }

    @Nullable
    public <T> ChangedRef<T> getChangedFieldRef(ImmutableProp prop) {
        return this.getChangedFieldRef(prop.getId());
    }

    @Nullable
    public <T> ChangedRef<T> getChangedFieldRef(TypedProp<?, ?> prop) {
        return this.getChangedFieldRef(prop.unwrap().getId());
    }

    @Nullable
    public <T> ChangedRef<T> getChangedFieldRef(int propId) {
        Object newValue;
        ImmutableProp prop = this.getImmutableType().getProp(propId);
        if (!(prop.getStorage() instanceof Column)) {
            throw new IllegalArgumentException("Cannot get the unchanged the value of \"" + prop + "\" because it is not a property mapped by column");
        }
        ImmutableSpi oe = (ImmutableSpi)this.oldEntity;
        ImmutableSpi ne = (ImmutableSpi)this.newEntity;
        if (oe == null) {
            if (!ne.__isLoaded(propId)) {
                return null;
            }
            Object newValue2 = ne.__get(propId);
            if (newValue2 == null) {
                return null;
            }
            return new ChangedRef<Object>(null, newValue2);
        }
        if (ne == null) {
            if (!oe.__isLoaded(propId)) {
                return null;
            }
            Object oldValue = oe.__get(propId);
            if (oldValue == null) {
                return null;
            }
            return new ChangedRef<Object>(oldValue, null);
        }
        if (!oe.__isLoaded(propId) || !ne.__isLoaded(propId)) {
            return null;
        }
        Object oldValue = oe.__get(propId);
        if (this.valueEqual(prop, oldValue, newValue = ne.__get(propId))) {
            return null;
        }
        return new ChangedRef<Object>(oldValue, newValue);
    }

    public int hashCode() {
        return Objects.hash(this.oldEntity, this.newEntity, this.reason);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityEvent event = (EntityEvent)o;
        return Objects.equals(this.oldEntity, event.oldEntity) && Objects.equals(this.newEntity, event.newEntity) && Objects.equals(this.reason, event.reason);
    }

    public String toString() {
        return "Event{oldEntity=" + this.oldEntity + ", newEntity=" + this.newEntity + ", reason=" + this.reason + '}';
    }

    private boolean valueEqual(ImmutableProp prop, Object a, Object b) {
        if (!prop.isReference(TargetLevel.ENTITY)) {
            return Objects.equals(a, b);
        }
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int targetIdPropId = prop.getTargetType().getIdProp().getId();
        Object targetId1 = ((ImmutableSpi)a).__get(targetIdPropId);
        Object targetId2 = ((ImmutableSpi)b).__get(targetIdPropId);
        return targetId1.equals(targetId2);
    }

    public static enum Type {
        DELETE,
        INSERT,
        UPDATE;

    }
}

