/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.babyfish.jimmer.ImmutableObjects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.DraftContext;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.event.Triggers;

class MutationTrigger {
    private final List<ChangedObject> changedObjects = new ArrayList<ChangedObject>();

    MutationTrigger() {
    }

    public void modifyEntityTable(Object oldEntity, Object newEntity) {
        this.changedObjects.add(new ChangedEntity(oldEntity, newEntity));
    }

    public void insertMiddleTable(ImmutableProp prop, Object sourceId, Object targetId) {
        this.changedObjects.add(new ChangedMiddleData(prop, sourceId, null, targetId));
    }

    public void deleteMiddleTable(ImmutableProp prop, Object sourceId, Object targetId) {
        this.changedObjects.add(new ChangedMiddleData(prop, sourceId, targetId, null));
    }

    public void prepareSubmit(DraftContext ctx) {
        if (!this.changedObjects.isEmpty()) {
            for (ChangedObject changedObject : this.changedObjects) {
                if (!(changedObject instanceof ChangedEntity)) continue;
                ChangedEntity entity = (ChangedEntity)changedObject;
                entity.newEntity = ctx.resolveObject(entity.newEntity);
            }
        }
    }

    public void submit(JSqlClient sqlClient, Connection con) {
        if (!this.changedObjects.isEmpty()) {
            Triggers triggers = sqlClient.getTriggers(true);
            for (ChangedObject changedObject : this.changedObjects) {
                if (changedObject instanceof ChangedEntity) {
                    ChangedEntity entity = (ChangedEntity)changedObject;
                    triggers.fireEntityTableChange(entity.oldEntity, ImmutableObjects.toLonely((Object)entity.newEntity), con);
                    continue;
                }
                ChangedMiddleData association = (ChangedMiddleData)changedObject;
                if (association.detachedTargetId == null) {
                    triggers.fireMiddleTableInsert(association.prop, association.sourceId, association.attachedTargetId, con);
                    continue;
                }
                triggers.fireMiddleTableDelete(association.prop, association.sourceId, association.detachedTargetId, con);
            }
        }
    }

    private static class ChangedEntity
    implements ChangedObject {
        final Object oldEntity;
        Object newEntity;

        private ChangedEntity(Object oldEntity, Object newEntity) {
            this.oldEntity = oldEntity;
            this.newEntity = newEntity;
        }

        public String toString() {
            return "ChangedEntity{oldEntity=" + this.oldEntity + ", newEntity=" + this.newEntity + '}';
        }
    }

    private static class ChangedMiddleData
    implements ChangedObject {
        final ImmutableProp prop;
        final Object sourceId;
        final Object detachedTargetId;
        final Object attachedTargetId;

        private ChangedMiddleData(ImmutableProp prop, Object sourceId, Object detachedTargetId, Object attachedTargetId) {
            this.prop = prop;
            this.sourceId = sourceId;
            this.detachedTargetId = detachedTargetId;
            this.attachedTargetId = attachedTargetId;
        }

        public String toString() {
            return "ChangedAssociation{prop=" + this.prop + ", sourceId=" + this.sourceId + ", detachedTargetId=" + this.detachedTargetId + ", attachedTargetId=" + this.attachedTargetId + '}';
        }
    }

    private static interface ChangedObject {
    }
}

