/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractPredicate;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

class BetweenPredicate
extends AbstractPredicate {
    private final boolean negative;
    private final Expression<?> expression;
    private final Expression<?> min;
    private final Expression<?> max;

    public BetweenPredicate(boolean negative, Expression<?> expression, Expression<?> min, Expression<?> max) {
        this.negative = negative;
        this.expression = expression;
        this.min = min;
        this.max = max;
    }

    @Override
    public int precedence() {
        return 7;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        ((Ast)((Object)this.expression)).accept(visitor);
        ((Ast)((Object)this.min)).accept(visitor);
        ((Ast)((Object)this.max)).accept(visitor);
    }

    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        this.renderChild((Ast)((Object)this.expression), builder);
        builder.sql(this.negative ? " not between " : " between ");
        this.renderChild((Ast)((Object)this.min), builder);
        builder.sql(" and ");
        this.renderChild((Ast)((Object)this.max), builder);
    }

    @Override
    public Predicate not() {
        return new BetweenPredicate(!this.negative, this.expression, this.min, this.max);
    }
}

