/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.PropExpressionImpl;
import org.babyfish.jimmer.sql.ast.impl.query.UseTableVisitor;
import org.babyfish.jimmer.sql.ast.impl.table.StatementContext;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.mutation.MutableUpdate;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.dialect.UpdateJoin;
import org.babyfish.jimmer.sql.meta.Column;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.babyfish.jimmer.sql.runtime.TableUsedState;
import org.jetbrains.annotations.NotNull;

public class MutableUpdateImpl
extends AbstractMutableStatementImpl
implements MutableUpdate,
Ast {
    private final StatementContext ctx;
    private Map<Target, Expression<?>> assignmentMap = new LinkedHashMap();

    public MutableUpdateImpl(JSqlClient sqlClient, ImmutableType immutableType) {
        super(sqlClient, immutableType);
        this.ctx = new StatementContext(ExecutionPurpose.UPDATE, false);
    }

    public MutableUpdateImpl(JSqlClient sqlClient, TableProxy<?> table) {
        super(sqlClient, table);
        this.ctx = new StatementContext(ExecutionPurpose.UPDATE, false);
    }

    @Override
    public StatementContext getContext() {
        return this.ctx;
    }

    @Override
    public AbstractMutableStatementImpl getParent() {
        return null;
    }

    @Override
    public <X> MutableUpdate set(PropExpression<X> path, X value) {
        if (value != null) {
            return this.set(path, Expression.any().value(value));
        }
        return this.set(path, Expression.any().nullValue(((ExpressionImplementor)((Object)path)).getType()));
    }

    @Override
    public <X> MutableUpdate set(PropExpression<X> path, Expression<X> value) {
        boolean joinedTableUpdatable;
        this.validateMutable();
        Target target = Target.of(path);
        if (!(target.prop.getStorage() instanceof Column)) {
            throw new IllegalArgumentException("The assigned prop expression must be mapped as column");
        }
        UpdateJoin updateJoin = this.getSqlClient().getDialect().getUpdateJoin();
        boolean bl = joinedTableUpdatable = updateJoin != null && updateJoin.isJoinedTableUpdatable();
        if (!joinedTableUpdatable && target.table != this.getTable() && target.table != this.getTableImplementor()) {
            throw new IllegalArgumentException("The current dialect '" + this.getSqlClient().getDialect().getClass().getName() + "' indicates that only the columns of current table can be updated");
        }
        if (this.assignmentMap.put(target, value) != null) {
            throw new IllegalStateException("Cannot update same column twice");
        }
        return this;
    }

    @Override
    public MutableUpdate where(Predicate ... predicates) {
        return (MutableUpdate)super.where(predicates);
    }

    @Override
    public Integer execute() {
        return this.getSqlClient().getConnectionManager().execute(this::executeImpl);
    }

    @Override
    public Integer execute(Connection con) {
        if (con != null) {
            return this.executeImpl(con);
        }
        return this.getSqlClient().getConnectionManager().execute(this::executeImpl);
    }

    private Integer executeImpl(Connection con) {
        this.freeze();
        if (this.assignmentMap.isEmpty()) {
            return 0;
        }
        SqlBuilder builder = new SqlBuilder(new AstContext(this.getSqlClient()));
        this.renderTo(builder);
        Tuple2<String, List<Object>> sqlResult = builder.build();
        return this.getSqlClient().getExecutor().execute(con, sqlResult.get_1(), sqlResult.get_2(), this.getPurpose(), null, PreparedStatement::executeUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(@NotNull AstVisitor visitor) {
        AstContext astContext = visitor.getAstContext();
        astContext.pushStatement(this);
        try {
            for (Map.Entry<Target, Expression<?>> e : this.assignmentMap.entrySet()) {
                ((Ast)((Object)e.getKey().expr)).accept(visitor);
                ((Ast)((Object)e.getValue())).accept(visitor);
            }
            Predicate predicate = this.getPredicate();
            if (predicate != null) {
                ((Ast)((Object)predicate)).accept(visitor);
            }
        }
        finally {
            astContext.popStatement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        AstContext astContext = builder.getAstContext();
        astContext.pushStatement(this);
        try {
            TableImplementor<?> table = this.getTableImplementor();
            Dialect dialect = this.getSqlClient().getDialect();
            this.accept(new VisitorImpl(builder.getAstContext(), dialect));
            builder.sql("update ").sql(table.getImmutableType().getTableName()).sql(" ").sql(table.getAlias());
            UpdateJoin updateJoin = dialect.getUpdateJoin();
            if (updateJoin != null && updateJoin.getFrom() == UpdateJoin.From.UNNECESSARY) {
                for (TableImplementor tableImplementor : table) {
                    tableImplementor.renderTo(builder);
                }
            }
            builder.sql(" set ");
            this.renderAssignments(builder);
            this.renderTables(builder);
            this.renderDeeperJoins(builder);
            this.renderPredicates(builder);
        }
        finally {
            astContext.popStatement();
        }
    }

    private void renderAssignments(SqlBuilder builder) {
        TableImplementor<?> table = this.getTableImplementor();
        UpdateJoin updateJoin = this.getSqlClient().getDialect().getUpdateJoin();
        boolean withTargetPrefix = updateJoin != null && updateJoin.isJoinedTableUpdatable() && MutableUpdateImpl.hasUsedChild(table, builder.getAstContext());
        String separator = "";
        for (Map.Entry<Target, Expression<?>> e : this.assignmentMap.entrySet()) {
            builder.sql(separator);
            this.renderTarget(builder, e.getKey(), withTargetPrefix);
            builder.sql(" = ");
            ((Ast)((Object)e.getValue())).renderTo(builder);
            separator = ", ";
        }
    }

    private void renderTarget(SqlBuilder builder, Target target, boolean withPrefix) {
        if (withPrefix) {
            TableImplementor<?> impl = TableProxies.resolve(target.table, builder.getAstContext());
            builder.sql(impl.getAlias()).sql(".");
        }
        builder.sql(((Column)target.prop.getStorage()).getName());
    }

    private void renderTables(SqlBuilder builder) {
        TableImplementor<?> table = this.getTableImplementor();
        if (MutableUpdateImpl.hasUsedChild(table, builder.getAstContext())) {
            switch (this.getSqlClient().getDialect().getUpdateJoin().getFrom()) {
                case AS_ROOT: {
                    table.renderTo(builder);
                    break;
                }
                case AS_JOIN: {
                    builder.sql(" from ");
                    String separator = "";
                    for (TableImplementor tableImplementor : table) {
                        builder.sql(separator);
                        tableImplementor.renderJoinAsFrom(builder, TableImplementor.RenderMode.FROM_ONLY);
                        separator = ",";
                    }
                    break;
                }
            }
        }
    }

    private void renderDeeperJoins(SqlBuilder builder) {
        TableImplementor<?> table = this.getTableImplementor();
        UpdateJoin updateJoin = this.getSqlClient().getDialect().getUpdateJoin();
        if (updateJoin != null && updateJoin.getFrom() == UpdateJoin.From.AS_JOIN && MutableUpdateImpl.hasUsedChild(table, builder.getAstContext())) {
            for (TableImplementor tableImplementor : table) {
                tableImplementor.renderJoinAsFrom(builder, TableImplementor.RenderMode.DEEPER_JOIN_ONLY);
            }
        }
    }

    private void renderPredicates(SqlBuilder builder) {
        Predicate predicate;
        TableImplementor<?> table = this.getTableImplementor();
        UpdateJoin updateJoin = this.getSqlClient().getDialect().getUpdateJoin();
        String separator = " where ";
        if (updateJoin != null && updateJoin.getFrom() == UpdateJoin.From.AS_JOIN && MutableUpdateImpl.hasUsedChild(table, builder.getAstContext())) {
            for (TableImplementor tableImplementor : table) {
                builder.sql(separator);
                separator = " and ";
                tableImplementor.renderJoinAsFrom(builder, TableImplementor.RenderMode.WHERE_ONLY);
            }
        }
        if ((predicate = this.getPredicate()) != null) {
            builder.sql(separator);
            ((Ast)((Object)predicate)).renderTo(builder);
        }
    }

    private static boolean hasUsedChild(TableImplementor<?> tableImplementor, AstContext astContext) {
        for (TableImplementor tableImplementor2 : tableImplementor) {
            if (astContext.getTableUsedState(tableImplementor2) != TableUsedState.USED) continue;
            return true;
        }
        return false;
    }

    private static class Target {
        Table<?> table;
        ImmutableProp prop;
        PropExpression<?> expr;

        private Target(Table<?> table, ImmutableProp prop, PropExpression<?> expr) {
            this.table = table;
            this.prop = prop;
            this.expr = expr;
        }

        static Target of(PropExpression<?> expr) {
            ImmutableProp prop;
            Table<?> parent;
            PropExpressionImpl exprImpl = (PropExpressionImpl)expr;
            Table<?> targetTable = exprImpl.getTable();
            if (targetTable instanceof TableImplementor) {
                parent = ((TableImplementor)targetTable).getParent();
                prop = ((TableImplementor)targetTable).getJoinProp();
            } else {
                parent = ((TableProxy)targetTable).__parent();
                prop = ((TableProxy)targetTable).__prop();
            }
            if (parent != null && exprImpl.getProp().isId()) {
                return new Target(parent, prop, expr);
            }
            return new Target(targetTable, exprImpl.getProp(), expr);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Target target = (Target)o;
            return this.table.equals(target.table) && this.prop.equals((Object)target.prop);
        }

        public int hashCode() {
            return Objects.hash(this.table, this.prop);
        }
    }

    private static class VisitorImpl
    extends UseTableVisitor {
        private Dialect dialect;

        public VisitorImpl(AstContext astContext, Dialect dialect) {
            super(astContext);
            this.dialect = dialect;
        }

        @Override
        public void visitTableReference(TableImplementor<?> table, ImmutableProp prop) {
            super.visitTableReference(table, prop);
            this.validateTable(table);
        }

        private void validateTable(TableImplementor<?> tableImpl) {
            if (this.getAstContext().getTableUsedState(tableImpl) == TableUsedState.USED) {
                if (tableImpl.getParent() != null && this.dialect.getUpdateJoin() == null) {
                    throw new ExecutionException("Table joins for update statement is forbidden by the current dialect, but there is a join '" + tableImpl + "'.");
                }
                if (tableImpl.getParent() != null && tableImpl.getParent().getParent() == null && tableImpl.getJoinType() != JoinType.INNER && this.dialect.getUpdateJoin() != null && this.dialect.getUpdateJoin().getFrom() == UpdateJoin.From.AS_JOIN) {
                    throw new ExecutionException("The first level table joins cannot be outer join because current dialect '" + this.dialect.getClass().getName() + "' indicates that the first level table joins in update statement must be rendered as 'from' clause, but there is a first level table join whose join type is outer: '" + tableImpl + "'.");
                }
            }
            if (tableImpl.getParent() != null) {
                this.validateTable(tableImpl.getParent());
            }
        }
    }
}

