/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.DraftInterceptor;
import org.babyfish.jimmer.util.StaticCache;
import org.jetbrains.annotations.NotNull;

class DraftInterceptorManager {
    private final Map<ImmutableType, List<DraftInterceptor<?>>> interceptorMap;
    private final StaticCache<ImmutableType, DraftInterceptor<?>> cache = new StaticCache(this::create, true);

    DraftInterceptorManager(Collection<DraftInterceptor<?>> interceptors) {
        HashMap interceptorMap = new HashMap();
        for (DraftInterceptor<?> interceptor : interceptors) {
            if (interceptor == null) continue;
            Collection types = TypeUtils.getTypeArguments(interceptor.getClass(), DraftInterceptor.class).values();
            if (types.isEmpty()) {
                throw new IllegalArgumentException("Illegal draft interceptor type \"" + interceptor.getClass().getName() + "\", it extends \"DraftInterceptor\" but the generic type is not specified");
            }
            Type draftType = (Type)types.iterator().next();
            if (!(draftType instanceof Class) || !((Class)draftType).isInterface()) {
                throw new IllegalArgumentException("Illegal draft interceptor type \"" + interceptor.getClass().getName() + "\", it extends \"DraftInterceptor\" but the generic type is not draft interface type");
            }
            ImmutableType immutableType = ImmutableType.get((Class)((Class)draftType));
            interceptorMap.computeIfAbsent(immutableType, it -> new ArrayList()).add(interceptor);
        }
        this.interceptorMap = interceptorMap;
    }

    public DraftInterceptor<?> get(ImmutableType type) {
        return (DraftInterceptor)this.cache.get((Object)type);
    }

    private DraftInterceptor<?> create(ImmutableType type) {
        final ArrayList interceptors = new ArrayList();
        for (ImmutableType t = type; t != null; t = t.getSuperType()) {
            List<DraftInterceptor<?>> list = this.interceptorMap.get(t);
            if (list == null) continue;
            interceptors.addAll(list);
        }
        if (interceptors.isEmpty()) {
            return null;
        }
        if (interceptors.size() == 1) {
            return (DraftInterceptor)interceptors.get(0);
        }
        return new DraftInterceptor<Draft>(){

            @Override
            public void beforeSave(@NotNull Draft draft, boolean isNew) {
                for (DraftInterceptor interceptor : interceptors) {
                    interceptor.beforeSave(draft, isNew);
                }
            }
        };
    }
}

