/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import java.util.StringJoiner;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.FieldFilter;
import org.babyfish.jimmer.sql.fetcher.RecursionStrategy;
import org.babyfish.jimmer.sql.fetcher.impl.DefaultRecursionStrategy;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImpl;
import org.babyfish.jimmer.sql.meta.Column;

class FieldImpl
implements Field {
    private final ImmutableType entityType;
    private final ImmutableProp prop;
    private final FieldFilter<?> filter;
    private final int batchSize;
    private final int limit;
    private final int offset;
    private final RecursionStrategy<?> recursionStrategy;
    private final FetcherImpl<?> childFetcher;
    private final boolean isSimpleField;

    FieldImpl(ImmutableType entityType, ImmutableProp prop, FieldFilter<?> filter, int batchSize, int limit, int offset, RecursionStrategy<?> recursionStrategy, FetcherImpl<?> childFetcher) {
        this.entityType = entityType;
        this.prop = prop;
        this.filter = filter;
        this.batchSize = batchSize;
        this.limit = limit;
        this.offset = offset;
        this.recursionStrategy = recursionStrategy;
        this.childFetcher = childFetcher;
        this.isSimpleField = this.determineIsSimpleField();
    }

    @Override
    public ImmutableType getEntityType() {
        return this.entityType;
    }

    @Override
    public ImmutableProp getProp() {
        return this.prop;
    }

    @Override
    public FieldFilter<?> getFilter() {
        return this.filter;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public RecursionStrategy<?> getRecursionStrategy() {
        return this.recursionStrategy;
    }

    @Override
    public Fetcher<?> getChildFetcher() {
        return this.childFetcher;
    }

    @Override
    public boolean isSimpleField() {
        return this.isSimpleField;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "(", ")").setEmptyValue("");
        if (this.batchSize != 0) {
            joiner.add("batchSize: " + this.batchSize);
        }
        if (this.limit != Integer.MAX_VALUE) {
            joiner.add("limit: " + this.limit);
        }
        if (this.recursionStrategy instanceof DefaultRecursionStrategy) {
            int depth = ((DefaultRecursionStrategy)this.recursionStrategy).getDepth();
            if (depth == Integer.MAX_VALUE) {
                joiner.add("recursive: true");
            } else if (depth > 1) {
                joiner.add("depth: " + depth);
            }
        } else if (this.recursionStrategy != null) {
            joiner.add("recursive: <java-code>");
        }
        if (this.childFetcher == null) {
            return this.prop.getName() + joiner;
        }
        return this.prop.getName() + joiner + this.childFetcher.toString(false);
    }

    private boolean determineIsSimpleField() {
        if (this.prop.getStorage() instanceof Column) {
            return this.childFetcher == null || this.childFetcher.getFieldMap().size() == 1;
        }
        return false;
    }
}

